--manual changes: 
--give yourself a torch & wield it.

local score = 0

if minetest.get_modpath("animalworld") then
	local bat_def = minetest.registered_entities["animalworld:bat"]
	assert(bat_def, "animalworld:bat not found")
	-- Override some properties of the bat entity
			bat_def.passive = false
			bat_def.type = "monster"
			bat_def.runaway = false
			bat_def.runaway_from = nil
end

-- Define a function to check if the shift key is pressed
local function isShiftPressed(player)
    local player_name = player:get_player_name()
    local keys = player:get_player_control()
    return keys["aux1"] -- 'aux1' represents the shift key
end

--[[
-- Register an event handler to check for shift key presses
minetest.register_globalstep(function(dtime)
    for _, player in ipairs(minetest.get_connected_players()) do
        if isShiftPressed(player) then
            -- Shift key is pressed
            minetest.log("x", "Shift key is pressed!")
        else
            -- Shift key is not pressed
           -- minetest.chat_send_player(player:get_player_name(), "Shift key is not pressed.")
        end
    end
end)
]]

minetest.register_node("boulder_dig:gemstone", {
	description = ("Gemtstone"),
	--tiles = {"default_stone.png^default_mineral_diamond.png"},
	tiles = {"amethyst_star.png"},
	groups = {cracky = 1},
	drop = "boulder_dig:gemstone",
	sounds = default.node_sound_stone_defaults(),
	light_source = 5, 
})


local function gemstoneTouchAction(player)
	local pos = player:get_pos()
	--minetest.swap_node(pos, {name = "hero_mines:broken_mese_post_light", param2 = node.param2})
	local got_gem = false
	for dx = -2, 2 do
		for dy = -2, 2 do
			for dz = -2, 2 do
				local neighbor_pos = {x = pos.x + dx, y = pos.y + dy, z = pos.z + dz}
				local node = minetest.get_node(neighbor_pos)
				
				if node.name == "boulder_dig:gemstone" then
					minetest.swap_node(neighbor_pos, {name = "air", param2 = node.param2})
					got_gem = true
				end
			end
		end
	end
	if got_gem then
		minetest.sound_play("default_break_glass", {pos = pos, gain = 0.5, max_hear_distance = 10})
		score = score + 10
		minetest.log("x", "score:"..score)
	end
end

registerNodeTouchAction("boulder_dig:gemstone", gemstoneTouchAction)

dirt = {"default:dirt","default:dry_dirt"}
minetest.register_ore({
    ore_type = "scatter",
    ore = "boulder_dig:gemstone",
    wherein = dirt,
	--7>11>9
    --clust_scarcity = 7 * 7 * 7,
	clust_scarcity = 9 * 9 * 9,
    clust_num_ores = 8,
    clust_size = 4,
    height_min = -31000,
    height_max = 1000,
})