-- Load dripstone API

local modpath = minetest.get_modpath(minetest.get_current_modname())

local function load(name)
    dofile(modpath.."/"..name..".lua")
end

load("api")

-- Choose dripstone sounds
local dripstone_sounds
if minetest.get_modpath("mcl_sounds") then
	dripstone_sounds = mcl_sounds.node_sound_stone_defaults()
end

-- Register droplet types
dripstone.register_droplet("water")
dripstone.register_droplet("lava")

-- Register dripstone types
dripstone.register_dripstone("dry", {
	sounds = dripstone_sounds,
	tiles = {
		"dripstone_dripstone_top.png",
		"dripstone_dripstone_top.png",
		"dripstone_dripstone_side.png",
	},
	on_droplet_receive = {
		water = "watered",
		lava = "molten",
	},
})
dripstone.register_dripstone("watered", {
	drop = dripstone.size_to_name("dry", 1),
	grow_to = "dry",
	on_droplet_receive = {
		lava = "hardened",
	},
	sounds = dripstone_sounds,
	tiles = {
		"dripstone_watered_dripstone_top.png",
		"dripstone_watered_dripstone_top.png",
		"dripstone_watered_dripstone_side.png",
	},
	trickle_down = "water",
})
dripstone.register_dripstone("molten", {
	drop = dripstone.size_to_name("dry", 1),
	grow_to = "dry",
	on_droplet_receive = {
		water = "hardened",
	},
	sounds = dripstone_sounds,
	tiles = {
		"dripstone_molten_dripstone_top.png",
		"dripstone_molten_dripstone_top.png",
		"dripstone_molten_dripstone_side.png",
	},
	trickle_down = "lava",
	trickle_speed = 6,
})
dripstone.register_dripstone("hardened", {
	sounds = dripstone_sounds,
	tiles = {
		"dripstone_hardened_dripstone_top.png",
		"dripstone_hardened_dripstone_top.png",
		"dripstone_hardened_dripstone_side.png",
	}
})

-- Register droplet sources above dripstone blocks

if minetest.get_modpath("default") then
	dripstone.add_droplet_source("water", "default:river_water_source")
	dripstone.add_droplet_source("water", "default:water_source")
	dripstone.add_droplet_source("lava", "default:lava_source")
end

if minetest.get_modpath("mcl_core") then
	dripstone.add_droplet_source("water", "mcl_core:water_source")
	dripstone.add_droplet_source("lava", "mcl_core:lava_source")
end

if minetest.get_modpath("mclx_core") then
	dripstone.add_droplet_source("water", "mclx_core:river_water_source")
end
