--[[
Minerals Defualt Module by Noriel_Sylvire.
This module implements an API for registering minerals for minetest default mod.
Node, oregen, craftitems, crafting (recipes), tools, and all other
definitions typically associated with a mineral in minetest are
registered automatically by this API.

Copyright (c) 2020-2023 Noriel_Sylvire.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

Contact Noriel_Sylvire via private message on the Minetest Forum:
https://forum.minetest.net/memberlist.php?mode=viewprofile&u=24116
or any of my social media attached to my Minetest Forum profile,
such as GitHub: https://github.com/
or Twitter: https://twitter.com/Noriel_Sylvire
--]]

nsmc.default_version = 1.2

local default_path = minetest.get_modpath("ns_minerals_default")

dofile(default_path.."/crafting.lua")
dofile(default_path.."/craftitems.lua")
dofile(default_path.."/tools.lua")
dofile(default_path.."/nodes.lua")
dofile(default_path.."/oregen.lua")

function nsmc.register_default(modname, mineral)

	mineral.mineral_type = mineral.mineral_type or "metal"
	
	mineral.flammable = mineral.flammable or false
	mineral.burntime = mineral.burntime or nslib.tern(mineral.flammable, 1, 0)
	mineral.block_burntime = mineral.block_burntime or (mineral.burntime * 9 + 5)
	mineral.ctime = mineral.ctime or 6
	
	-- any texture you do not provide yourself will be generated by nsmc
	mineral.material_texture_index = nslib.clamp(mineral.material_texture_index, 1, nslib.tern(mineral.mineral_type == "metal", 2, 3)) or 2
	mineral.lump_texture_index = nslib.clamp(mineral.lump_texture_index, 1, 3) or 1
	
	mineral.material_colorize = mineral.material_colorize or nslib.tern(mineral.material_texture ~= nil, false, true)
	if mineral.mineral_type == "metal" then
		mineral.material_texture = mineral.material_texture or mineral.texture_brightness.."_ingot_"..mineral.material_texture_index
		mineral.lump_colorize = mineral.lump_colorize or nslib.tern(mineral.lump_texture ~= nil, false, true)
		mineral.lump_texture = mineral.lump_texture or mineral.texture_brightness.."_lump_"..mineral.lump_texture_index
	else
		mineral.material_texture = mineral.material_texture or mineral.texture_brightness.."_crystal_"..mineral.material_texture_index
	end
	
	mineral.ore = mineral.ore or {}
	mineral.ore.colorize = mineral.ore.colorize or nslib.tern(mineral.ore.tiles ~= nil, false, true) -- by default, textures you provide are not colorized
	mineral.ore.tiles = mineral.ore.tiles or { mineral.texture_brightness.."_ore_overlay" }	-- leave this blank to use the default ore texture
	mineral.ore.wherein_texture = mineral.ore.wherein_texture or "default_stone.png"	-- only modify this if you do not want the ore to generate in stone
	mineral.ore.groups = mineral.ore.groups or { cracky = 2 }
	
	mineral.block = mineral.block or {}
	mineral.block.colorize = mineral.block.colorize or nslib.tern(mineral.block.tiles ~= nil, false, true)
	mineral.block.tiles = mineral.block.tiles or { mineral.texture_brightness.."_"..nslib.tern(mineral.mineral_type == "metal", "metal", "gem").."_block" }
	mineral.block.groups = mineral.block.groups or { cracky = 2 }
	
	mineral.axe = mineral.axe or {}
	mineral.axe.colorize = mineral.axe.colorize or nslib.tern(mineral.axe.texture ~= nil, false, true)
	mineral.axe.texture_handle = mineral.axe.texture_handle or "axe_handle"
	mineral.axe.texture_head = mineral.axe.texture_head or mineral.texture_brightness.."_axe_head"
	mineral.axe.full_punch_interval = mineral.axe.full_punch_interval or 1.0
	mineral.axe.times = mineral.axe.times or { [1] = 2.50, [2] = 1.40, [3] = 1.00 }
	mineral.axe.uses = mineral.axe.uses or 20
	mineral.axe.maxlevel = mineral.axe.maxlevel or 2
	mineral.axe.damage = mineral.axe.damage or 4
	
	mineral.sword = mineral.sword or {}
	mineral.sword.colorize = mineral.sword.colorize or nslib.tern(mineral.sword.texture ~= nil, false, true)
	mineral.sword.texture_handle = mineral.sword.texture_handle or "sword_handle"
	mineral.sword.texture_blade = mineral.sword.texture_blade or mineral.texture_brightness.."_sword_blade"
	mineral.sword.full_punch_interval = mineral.sword.full_punch_interval or 0.8
	mineral.sword.times = mineral.sword.times or { [1] = 2.5, [2] = 1.20, [3] = 0.35 }
	mineral.sword.uses = mineral.sword.uses or 30
	mineral.sword.maxlevel = mineral.sword.maxlevel or 2
	mineral.sword.damage = mineral.sword.damage or 6
	
	mineral.pick = mineral.pick or {}
	mineral.pick.colorize = mineral.pick.colorize or nslib.tern(mineral.pick.texture ~= nil, false, true)
	mineral.pick.texture_handle = mineral.pick.texture_handle or "pick_handle"
	mineral.pick.texture_head = mineral.pick.texture_head or mineral.texture_brightness.."_pick_head"
	mineral.pick.full_punch_interval = mineral.pick.full_punch_interval or 1.0
	mineral.pick.times = mineral.pick.times or { [1] = 4.00, [2] = 1.60, [3] = 0.80 }
	mineral.pick.uses = mineral.pick.uses or 20
	mineral.pick.maxlevel = mineral.pick.maxlevel or 2
	mineral.pick.damage = mineral.pick.damage or 4
	
	mineral.shovel = mineral.shovel or {}
	mineral.shovel.colorize = mineral.shovel.colorize or nslib.tern(mineral.shovel.texture ~= nil, false, true)
	mineral.shovel.texture_handle = mineral.shovel.texture_handle or "shovel_handle"
	mineral.shovel.texture_head = mineral.shovel.texture_head or mineral.texture_brightness.."_shovel_head"
	mineral.shovel.full_punch_interval = mineral.shovel.full_punch_interval or 1.1
	mineral.shovel.times = mineral.shovel.times or { [1] = 1.50, [2] = 0.90, [3] = 0.40 }
	mineral.shovel.uses = mineral.shovel.uses or 30
	mineral.shovel.maxlevel = mineral.shovel.maxlevel or 2
	mineral.shovel.damage = mineral.shovel.damage or 3
	
	mineral.oregen = mineral.oregen or {}	-- this bit here is used by normal ore generation, regardless of installed mods and settings
	mineral.oregen.wherein_node = mineral.oregen.wherein_node or "default:stone"
	mineral.oregen.scarcity = mineral.oregen.scarcity or { 7, 24 }
	mineral.oregen.num_ores = mineral.oregen.num_ores or { 5, 27 }
	mineral.oregen.size = mineral.oregen.size or { 3, 6 }
	mineral.oregen.max = mineral.oregen.max or { 0, -64 }
	mineral.oregen.min = mineral.oregen.min or { -31000, -31000 }
	
	nsmc.register_crafts(modname, mineral)
	nsmc.register_craftitems(modname, mineral)
	nsmc.register_tools(modname, mineral)
	nsmc.register_oregen(modname, mineral)
	nsmc.register_nodes(modname, mineral)
end

nsmc.register_callback(nsmc.register_default)
