# powerbanks

[![Build Status](https://travis-ci.org/OgelGames/powerbanks.svg?branch=master)](https://travis-ci.org/OgelGames/powerbanks)
[![License](https://img.shields.io/badge/License-MIT%20and%20CC%20BY--SA%204.0-green.svg)](LICENSE.md)

## Table of Contents

- [Overview](#overview)
- [Features](#features)
- [Usage](#usage)
- [Powerbank versions](#powerbank-versions)
- [Dependencies](#dependencies)
- [Installation](#installation)
- [License](#license)

## Overview

This mod adds portable powerbanks used to charge technic tools.

![Overview Screenshot](screenshots/overview.png?raw=true "Overview Screenshot") 

## Features

- **Fully portable** - charge will remain no matter how many times you place and pick it up!
- **Self-protected** - no need to worry about leaving your powerbank while it's charging your tools, only you can pick it up!
- **Fast charging** - each version charges faster than its technic battery equivalent (LV, MV, HV).
- **Multiple charging slots** - powerbanks can charge more than one tool at once! (except for Mk1)

## Usage

1. Obtain a powerbank (obviously :P).
2. Charge the powerbank.

![Charging a Powerbank](screenshots/charging.png?raw=true "Charging a Powerbank")

3. Place the powerbank down in the world, and open it by interacting with it.
4. Put your tool(s) in the charging slot(s) and watch them charge! (or leave it to charge while you do something else...)

![Powerbank Formspec](screenshots/formspec.png?raw=true "Powerbank Formspec")

## Powerbank versions

Currently there are three different powerbanks:

- #### Powerbank Mk1
  
  - Capacity: 300kEU
  
  - Charging slots: 1
  
  - Recipe:
  
  ![Mk1 Recipe](screenshots/mk1_recipe.png?raw=true "Mk1 Recipe")

- #### Powerbank Mk2
  
  - Capacity: 600kEU
  
  - Charging slots: 2
  
  - Recipe:
  
  ![Mk2 Recipe](screenshots/mk2_recipe.png?raw=true "Mk2 Recipe")

- #### Powerbank Mk3
  
  - Capacity: 1200kEU
  
  - Charging slots: 3
  
  - Recipe:
  
  ![Mk3 Recipe](screenshots/mk3_recipe.png?raw=true "Mk3 Recipe") 

## Dependencies

Currently this mod only depends on the default and [technic](https://github.com/minetest-mods/technic) mods.

## Installation

To install this mod, simply download it using one of the methods below, and place it in one of [Minetest's mod folders](https://dev.minetest.net/Installing_Mods).

- Clone the Git repository using `git clone https://github.com/OgelGames/powerbanks.git` or the [GitHub Desktop](https://desktop.github.com/) app.
- Download the Git repository as a ZIP file: https://github.com/OgelGames/powerbanks/archive/master.zip
- Download the latest stable release: https://github.com/OgelGames/powerbanks/releases

## License

Except for the exceptions stated in [LICENSE.md](LICENSE.md#exceptions), all code is licensed under the [MIT License](LICENSE.md#mit-license), with textures licensed under the [CC BY-SA 4.0 License](LICENSE.md#cc-by-sa-40-license).
