# Powerbanks [powerbanks]

[![luacheck](https://github.com/OgelGames/powerbanks/workflows/luacheck/badge.svg)](https://github.com/OgelGames/powerbanks/actions)
[![License](https://img.shields.io/badge/License-MIT%20and%20CC%20BY--SA%204.0-green.svg)](LICENSE.md)
[![Minetest%20Forum](https://img.shields.io/badge/Minetest%20Forum-Feedback-lightgrey.svg)](https://forum.minetest.net/viewtopic.php?t=23791)
[![ContentDB](https://content.minetest.net/packages/OgelGames/powerbanks/shields/downloads/)](https://content.minetest.net/packages/OgelGames/powerbanks/)

## Table of Contents

- [Overview](#overview)
- [Features](#features)
- [Usage](#usage)
- [Powerbank versions](#powerbank-versions)
- [Dependencies](#dependencies)
- [Installation](#installation)
- [License](#license)

## Overview

This mod adds portable powerbanks used to charge technic tools.

![Overview Screenshot](screenshots/overview.png?raw=true "Overview Screenshot") 

## Features

- **Fully portable** - charge will remain no matter how many times you place and pick it up!
- **Self-protected** - no need to worry about leaving your powerbank while it's charging your tools, only you can pick it up!
- **Fast charging** - each version charges faster than its technic battery equivalent (LV, MV, HV).
- **Multiple charging slots** - powerbanks can charge more than one tool at once! (except for Mk1)

## Usage

1. Obtain a powerbank (obviously :P).
2. Charge the powerbank.

![Charging a Powerbank](screenshots/charging.png?raw=true "Charging a Powerbank")

3. Place the powerbank down in the world, and open it by interacting with it.
4. Put your tool(s) in the charging slot(s) and watch them charge! (or leave it to charge while you do something else...)

![Powerbank Formspec](screenshots/formspec.png?raw=true "Powerbank Formspec")

## Powerbank versions

Currently there are three different powerbanks:

- #### Powerbank Mk1
  
  - Capacity: 300kEU
  
  - Charging slots: 1
  
  - Recipe:
  
  ![Mk1 Recipe](screenshots/mk1_recipe.png?raw=true "Mk1 Recipe")

- #### Powerbank Mk2
  
  - Capacity: 600kEU
  
  - Charging slots: 2
  
  - Recipe:
  
  ![Mk2 Recipe](screenshots/mk2_recipe.png?raw=true "Mk2 Recipe")

- #### Powerbank Mk3
  
  - Capacity: 1200kEU
  
  - Charging slots: 3
  
  - Recipe:
  
  ![Mk3 Recipe](screenshots/mk3_recipe.png?raw=true "Mk3 Recipe") 

## Dependencies

**Required**

- `default` (included in [Minetest Game](https://github.com/minetest/minetest_game))

- [`technic`](https://github.com/minetest-mods/technic)

## Installation

Download the [master branch](https://github.com/OgelGames/powerbanks/archive/master.zip) or the [latest release](https://github.com/OgelGames/powerbanks/releases), or clone the repository using Git or the [GitHub Desktop](https://desktop.github.com/) app, and follow [these instructions](https://dev.minetest.net/Installing_Mods).

Alternatively, you can download and install the mod from [ContentDB](https://content.minetest.net/packages/OgelGames/powerbanks) from the online content tab in Minetest.

## License

Except for any exceptions stated in [LICENSE.md](LICENSE.md#exceptions), all code is licensed under the [MIT License](LICENSE.md#mit-license), with all textures, models, sounds, and other media licensed under the [CC BY-SA 4.0 License](LICENSE.md#cc-by-sa-40-license). 
