# Cloud Items

![Screenshot](https://user-images.githubusercontent.com/51391473/87363638-328a0280-c537-11ea-9e90-f992cbc13ab4.png)

[![Build status](https://github.com/Panquesito7/cloud_items/workflows/build/badge.svg)](https://github.com/Panquesito7/cloud_items/actions)
[![License](https://img.shields.io/badge/license-LGPLv2.1%2B-blue.svg)](https://www.gnu.org/licenses/old-licenses/lgpl-2.1.en.html)

Adds powerful cloud tools for Minetest.  
Stronger than diamond and other materials.  

## Installation

- Unzip the archive, rename the folder to `cloud_items` and
place it in .. minetest/mods/

- GNU/Linux: If you use a system-wide installation place
    it in ~/.minetest/mods/.

- If you only want this to be used in a single world, place
    the folder in .. worldmods/ in your world directory.

For further information or help, see:\
<https://wiki.minetest.net/Installing_Mods>

## Features

Take a look at this mod's features.\
Have any questions/comments? Submit an [issue](https://github.com/Panquesito7/cloud_items/issues/new) or [contact me](mailto:halfpacho@gmail.com).

### Difference beetwen normal ores

This "ore", doesn't spawn underground!\
Instead, it spawns at the sky; that's why it's called "cloud".

An ore will be spawned inside the schematic.\
You have less chances to find an ore, than not to find an ore.

Small schematic
![Small schematic](https://user-images.githubusercontent.com/51391473/69098689-af9fbf00-0a1e-11ea-9e88-c74a6b74baa3.png)

Medium schematic
![Medium schematic](https://user-images.githubusercontent.com/51391473/87362981-bfcc5780-c535-11ea-8caa-018af03e33d1.png)

Big schematic
![Big schematic](https://user-images.githubusercontent.com/51391473/87363085-03bf5c80-c536-11ea-8ab5-155a931e7400.png)

### Types of cloud

There are 4 types of cloud:

- Normal cloud
  - Hard to find.
  - You may find from 1 to 4 ores.
  - Stronger than diamond.
  - Damage: 9
    - Can kill players with 2 hits.
  - Spawns at 200 blocks and above.
- Cloud star (comming soon)
  - Difficult to find.
  - You may find from 1 to 4 ores.
  - Stronger than cloud and diamond.
  - Damage: 10
    - Can kill players with 2 hits.
  - Spawns at 350 blocks and above.  
- Cloud meteor (comming soon)
  - Very hard to find.
  - You may find from 1 to 3 ores.
  - Stronger than cloud (star) and diamond.
  - Damage: 12
    - Can kill players with 2 hits.
  - Spawns at 500 blocks and above.
- Cloud comet (comming soon)
  - Very difficult to find.
  - You may find only 1 ore.
  - Stronger than all materials.
  - Damage: 15
    - Very strong, can kill a player with 2 hits.
  - Spawns at 800 blocks and above.

## Dependencies

- `default` (included in [Minetest Game](https://github.com/minetest/minetest_game))

### Optional dependencies

- [`3d_armor`](https://github.com/minetest-mods/3d_armor)

## Requirements

Cloud Items is currently tested with Minetest 5.2.0.\
Issues may arise if you use older or newer versions.

It shall work with MT 5.0.0 and above, though.

## License

Copyright (C) 2019-2020 Panquesito7, David Leal\
Copyright (C) Various other Minetest developers/contributors

See [`LICENSE.md`](LICENSE.md) for more information.

## Credits

Credits to (in no particular order):

- Various Minetest developers/contributors
- [Brett O'Donnell](https://github.com/cornernote)
  - For the function to load an schematic.

## Issues, suggestions, features & bugfixes

Report bugs or suggest ideas by [creating an issue](https://github.com/Panquesito7/cloud_items/issues/new).\
If you know how to fix an issue, or want something to be added, consider opening a [pull request](https://github.com/Panquesito7/cloud_items/compare).
