-----------------
------MATH-------
-----------------
minetestd.math = {}

minetestd.math.sortp = function(minp, maxp)
	if not (type(minp) == "table" and type(maxp) == "table") then return end
	if minp.x > maxp.x then
		minp.x, maxp.x = maxp.x, minp.x
	end
	if minp.y > maxp.y then
		minp.y, maxp.y = maxp.y, minp.y
	end
	if minp.z > maxp.z then
		minp.z, maxp.z = maxp.z, minp.z
	end
	
	return minp, maxp
end

minetestd.math.volume_in_volume = function(minp1, maxp1, minp2, maxp2)
	minp1, maxp1 = minetestd.math.sortp(minp1, maxp1)
	minp2, maxp2 = minetestd.math.sortp(minp2, maxp2)
	return (minp1.x <= maxp2.x and minp2.x <= maxp1.x and
		minp1.y <= maxp2.y and minp2.y <= maxp1.y and
		minp1.z <= maxp2.z and minp2.z <= maxp1.z
	)
end

minetestd.math.pos_in_volume = function(pos, minp, maxp)
	minp, maxp = minetestd.math.sortp(minp, maxp)
	return (minp.x <= pos.x and pos.x <= maxp.x and
		minp.y <= pos.y and pos.y <= maxp.y and
		minp.z <= pos.z and pos.z <= maxp.z
	)
end

-----------------
---Table stuff---
-----------------

minetestd.tables = {}

minetestd.tables.get_keytable = function(t)
	if not (type(t) == "table") then return end
	local key_table = {}
	for k,_ in pairs(t) do
		table.insert(key_table, k)
	end
	return key_table
end

minetestd.tables.merge_tables=function(t1, t2, func, ...)
	local t = table.copy(t1)
	for k,v in pairs(t2) do
		if func and (t[k] ~= nil) then 
			t[k] = func(t[k], v, k, ...)
		else
			t[k] = v
		end
	end
	return t
end

minetestd.tables.smart_merge_values = function(v1, v2, _, shallow_tables)
	if (type(v1) == "table") then
		if (type(v2) == "table") then
			if shallow_tables then
				return minetestd.tables.merge_tables(v1,v2)
			else
				return minetestd.tables.smart_merge_values(v1,v2)
			end
		else
			table.insert(v1, v2)
		end
	elseif (type(v2) == "table") then
		table.insert(v2, v1)
	
	elseif (type(v1) == "userdata") or (type(v2) == "userdata") then return v2
	elseif (type(v1) == "function") 
		or (type(v2) == "function") 
		or (type(v1) == "CFunction") 
		or (type(v2) == "CFunction") 
	then
		if 
			((type(v1) == "function") or (type(v1) == "CFunction")) 
			and ((type(v2) == "function") or (type(v2) == "CFunction")) 
		then
			return (function(...) 
				return v1(v2(...))
			end)
		else
			return v2
		end
	elseif (type(v1) == "string") or (type(v2) == "string") then
		return tostring(v1)..tostring(v2)
	elseif (type(v1) == "boolean") and (type(v2) == "boolean") then
		return (v1 or v2)
	elseif (type(v1) == "number") or (type(v1) == "boolean") or (type(v2) == "number") or (type(v2) == "boolean") then
		if (type(v1) == "boolean") then
			v1 = v1 and 1 or 0
		end
		if (type(v2) == "boolean") then
			v2 = v2 and 1 or 0
		end
		return v1 + v2
	else
		return v2
	end
	
end


-----------------
----misc-util----
-----------------
minetestd.utils = {}


minetestd.utils.check_item_match = function(item_name, match, recurse_internal) 

	if type(match) == "string" then
		if item_name == match then return match end
		if string.sub(match,1,6) == "group:" then
			local group = string.sub(match,7)
			if minetest.registered_nodes[item_name] then
				if minetest.registered_nodes[item_name].groups[group] then return match end
			elseif minetest.registered_items[item_name] then
				if minetest.registered_items[item_name].groups[group] then return match end
			end
		elseif match == "minetest:node" and minetest.registered_nodes[item_name] then
			return match
		end
		return nil
	elseif type(match) == "table" then
		for _,name in pairs(match) do
			local m = minetestd.utils.check_item_match(item_name, name, true)
			if m then
				if not recurse_internal then 
					return m
				else
					return match
				end 
			end
		end
	end
end

minetestd.utils.is_solid_block = function(pos)
	if not minetest.get_node_or_nil(pos) then return true end
	local def = minetest.registered_nodes[minetest.get_node(pos).name]
	if not def then return true end -- Unknown node is a solid block
	return (def.drawtype == "normal" and def.walkable ~= false)
end


minetestd.utils.get_light_info = function(pos)
	pos = vector.round(pos)
	if not (pos and minetest.get_node_light(pos)) then return end
	return {
		light=minetest.get_node_light(pos),
		day=minetest.get_node_light(pos, 0.5),
		night=minetest.get_node_light(pos, 0),
		skylit=(minetest.get_node_light(pos, 0.5) ~= minetest.get_node_light(pos, 0)),
		direct_sun=(minetest.get_node_light(pos, 0.5) >= 15),
	}
end

minetestd.utils.parse_chatargs = function(argstring) 
	local args = {""}
	local argc = 0
	if argstring ~= nil and argstring ~= "" and argstring ~= " " then
		args = string.split(argstring, " ")
		argc = #args 
	end
	return args, argc
end

minetestd.utils.pos_to_shorthand = function(p)
	local pos = vector.round(p)
	local sign = 0
	if pos.x < 0 then
		sign = sign + 1
		pos.x = math.abs(pos.x)
	end
	if pos.y < 0 then
		sign = sign + 2
		pos.y = math.abs(pos.y)
	end
	if pos.z < 0 then
		sign = sign + 4
		pos.z = math.abs(pos.z)
	end
	return sign..pos.x.."_"..pos.y.."_"..pos.z
end

minetestd.utils.shorthand_to_pos = function(str)
	local parts = string.split(str, "_")
	local sign = tonumber(string.sub(parts[1], 1, 1))
	parts[1] = string.sub(parts[1], 2, -1)
	return {
		x=tonumber(parts[1]) * (((sign%2) > 0) and -1 or 1),
		y=tonumber(parts[2]) * (((sign%4) > 1) and -1 or 1),
		z=tonumber(parts[3]) * ((sign > 3) and -1 or 1),
	}
end