--[[ init.lua
Copyright 2025 Pixelo789

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.

SPDX-License-Identifier: AGPL-3.0-or-later
--]]


local S = core.get_translator(core.get_current_modname())
register_node = core.register_node


local function register_button(num)
	local function on_interact(player, pos)
		core.sound_play("thinkingwitharrows_woosh", {start_time = 0.05})

		local level_info, level, section = thinkingwitharrows.get_level_info(player)
		level_info.sections[section].button_callback(pos, num, player)
	end
	register_node("thinkingwitharrows_buttons:button_block_" .. num, {
		description = S("Button Block"),
		tiles = {"thinkingwitharrows_buttons_button_block_" .. num .. ".png"},
		stack_max = 1000,
		groups = {oddly_breakable_by_hand = 2},
		is_ground_content = true,
		on_rightclick = function(pos, node, player)
			on_interact(player, pos)
		end,
		on_punch = function(pos, node, puncher, pointed_thing)
			local pt = pointed_thing or {}

			if pt.intersection_normal and pt.intersection_point and (puncher and puncher:is_player()) then
				on_interact(puncher, pos)
			end
		end
	})
end

register_button(1)
register_button(2)
