-- Copyright (c) 2013-18 rubenwardy and Wuzzy. MIT.

local S = awards.translator


-- You Suck!
awards.register_award("award_you_suck", {
	title = S("You Suck!"),
	description = S("Die 10 times."),
	trigger = {
		type = "death",
		target = 10
	},
	secret = true,
})

-- This ensures the following code is executed after all items have been registered
core.after(0, function()
	-- Builder series
	awards.register_award("awards_builder1", {
		title = S("Builder"),
		icon = "awards_builder.png^awards_level1.png",
		trigger = {
			type = "place",
			target = 50,
		},
	})
	awards.register_award("awards_builder2", {
		title = S("Engineer"),
		icon = "awards_engineer.png^awards_level2.png",
		trigger = {
			type = "place",
			target = 100,
		},
		requires = {"awards_builder1"},
	})
	awards.register_award("awards_builder3", {
		title = S("Architect"),
		icon = "awards_architect.png^awards_level3.png",
		trigger = {
			type = "place",
			target = 500,
		},
		requires = {"awards_builder1", "awards_builder2"},
	})
	awards.register_award("awards_builder4", {
		title = S("Master Architect"),
		icon = "awards_master_architect.png^awards_level4.png",
		trigger = {
			type = "place",
			target = 1000,
		},
		requires = {"awards_builder1", "awards_builder2", "awards_builder3"},
	})

	awards.register_award("awards_shoot1", {
		title = S("Beginning Archer"),
		--icon = "awards_master_architect.png^awards_level4.png",
		trigger = {
			type = "shoot",
			target = 25,
		},
		--requires = {"awards_builder1", "awards_builder2", "awards_builder3"},
	})
	awards.register_award("awards_shoot2", {
		title = S("Starting Archer"),
		--icon = "awards_master_architect.png^awards_level4.png",
		trigger = {
			type = "shoot",
			target = 100,
		},
		requires = {"awards_shoot1"},
	})
	awards.register_award("awards_shoot3", {
		title = S("Better Archer"),
		--icon = "awards_master_architect.png^awards_level4.png",
		trigger = {
			type = "shoot",
			target = 200,
		},
		requires = {"awards_shoot1", "awards_shoot2"},
	})
	awards.register_award("awards_shoot4", {
		title = S("Advanced Archer"),
		--icon = "awards_master_architect.png^awards_level4.png",
		trigger = {
			type = "shoot",
			target = 500,
		},
		requires = {"awards_shoot1", "awards_shoot2", "awards_shoot3"},
	})
	awards.register_award("awards_shoot5", {
		title = S("Expert Archer"),
		--icon = "awards_master_architect.png^awards_level4.png",
		trigger = {
			type = "shoot",
			target = 100,
		},
		requires = {"awards_shoot1", "awards_shoot2", "awards_shoot3", "awards_shoot4"},
	})

	--[[
	awards.register_award("awards_win", {
		title = S("Win"),
		--icon = "awards_master_architect.png^awards_level4.png",
		trigger = {
			type = "win",
		},
	})
	--]]
end)
