--[[ init.lua
Copyright 2025 Pixelo789

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.

SPDX-License-Identifier: AGPL-3.0-or-later
--]]


local S = core.get_translator(core.get_current_modname())


-- Privilege to change level to future levels
core.register_privilege("skip_levels", {
	description = S("Can skip levels"),
	give_to_singleplayer = false,
})

-- Add arrows command
core.register_chatcommand("add_arrows", {
	description = S("Add arrows to the arrow inventory"),
	params = "<value>",
	privs = {give = true},
	func = function(name, param)
		local num = tonumber(param)
		if num then
			local player = core.get_player_by_name(name)
			thinkingwitharrows_bows.add_arrows(player, num)
		end
	end
})

-- Check arrows command
core.register_chatcommand("check_arrows", {
	description = S("Check how many arrows are in your arrow inventory"),
	func = function(name)
		local player = core.get_player_by_name(name)
		local inv = player:get_inventory()
		local stack = inv:get_stack("x_bows:arrow_inv", 1)
		core.log("none", tostring(stack:is_empty()))
	end
})


-- Change level command
core.register_chatcommand("change_level", {
	description = S("Change the current level"),
	params = "<value>",
	func = function(name, param)
		local num = tonumber(param)
		if num then
			local player = core.get_player_by_name(name)
			local meta = player:get_meta()

			local level = meta:get_int("latest_level")
			if num > level and not core.check_player_privs(name, {skip_levels = true}) then
				core.chat_send_player(name, S("You don't have permission to run this command (missing privilges: skip_levels)."))
			else
				thinkingwitharrows.change_level_secondary(player, num)
			end
		end
	end
})


-- Toggle anti-gravity command
core.register_chatcommand("toggle_antigravity", {
	description = S("Toggle anti-gravity (moon gravity). Requires a secret key"),
	params = "<key>",
	func = function(name, param)
		if core.sha256(param) == "2a22f370859c8d329b84b5baf9d3d04dd210f6a098dc0b66e6dbef8db64eb472" then
			local player = core.get_player_by_name(name)
			local meta = player:get_meta()

			meta:set_int("speedrun_has_cheated", 1)

			thinkingwitharrows_antigravity.toggle_gravity(player)
			core.log("none", S("Anti-gravity toggled"))
		else
			core.log("none", S("Add the secret key to the command."))
		end
	end

})
