--[[ init.lua
Copyright 2025 Pixelo789

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.

SPDX-License-Identifier: AGPL-3.0-or-later
--]]


thinkingwitharrows_dialogue = {}
local modname = core.get_current_modname()
local S = core.get_translator(modname)

local texts = {}
local text_jobs = {}
local bgs = {}

local function get_raw_translation(player, str)
	local name = player:get_player_name()
	local info = core.get_player_information(name)
	local language = info and info.language or "en"

	return core.get_translated_string(language, str)
end


function thinkingwitharrows_dialogue._add_text(player, text, color)
	local name = player:get_player_name()

	-- compatibility with older versions of Luanti
	local hud_type
	if core.features.hud_def_type_field then
		hud_type = "type"
	else
		hud_type = "hud_elem_type"
	end

	local oldtext = texts[name]
	local color = color or 0xFFFFFF

	if oldtext then
		player:hud_change(oldtext, "text", text)
		player:hud_change(oldtext, "number", color)
	else
		texts[name] = player:hud_add {
			[hud_type] = "text",
			position = {x = 0.5, y = 0.8},
			alignment = {x = 0, y = 0},
			z_index = 999,
			scale = {x = -100, y = -100}, -- fullscreen
			text = text,
			number = color, -- color
		}
	end
end


function thinkingwitharrows_dialogue.remove_dialogue(player)
	local meta = player:get_meta()
	local name = player:get_player_name()

	if texts[name] then
		player:hud_remove(texts[name])
		texts[name] = nil
	end

	if bgs[name] then
		player:hud_remove(bgs[name])
		bgs[name] = nil
	end

	if text_jobs[name] then
		for _, v in pairs(text_jobs[name]) do
			v:cancel()
		end
	end
	text_jobs[name] = {}
end


function thinkingwitharrows_dialogue.queue_dialogue(player, text, colors, after_dialogue)
	local a = thinkingwitharrows_dialogue._add_text
	local r = thinkingwitharrows_dialogue.remove_dialogue

	r(player)

	local meta = player:get_meta()
	local name = player:get_player_name()

	-- compatibility with older versions of Luanti
	local hud_type
	if core.features.hud_def_type_field then
		hud_type = "type"
	else
		hud_type = "hud_elem_type"
	end

	-- background
	local oldbg = bgs[name]
	bgs[name] = player:hud_add {
		[hud_type] = "image",
		alignment = {x = 0, y = 0},
		position = {x = 0.5, y = 0.8},
		scale = {x = -80, y = -10}, -- fullscreen
		text = "thinkingwitharrows_init_black_box.png^[opacity:" .. 50,
		z_index = 998,
	}
	if oldbg then
		player:hud_remove(oldbg)
	end

	local text_length = 0
	text_jobs[name] = {}
	local colors = colors or {}
	for k, v in ipairs(text) do
		local tr = get_raw_translation(player, v)
		for i = 1, #tr do
			table.insert(text_jobs[name], core.after(i / 30 + text_length, function()
				a(player, v:sub(1, i), colors[k])
			end))
		end
		text_length = text_length + (#tr / 30) + 2
	end

	table.insert(text_jobs[name], core.after(text_length, function()
		r(player)
		if after_dialogue then
			after_dialogue(player)
		end
	end))
end
