--[[ init.lua
Copyright 2025 Pixelo789

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.

SPDX-License-Identifier: AGPL-3.0-or-later
--]]


thinkingwitharrows_bows = {}


local S = core.get_translator(core.get_current_modname())

-- Registers bow and arrow
XBows:register_bow("bow", {
	description = S("Bow"),
	short_description = S("Bow"),
	custom = {
		mod_name = "thinkingwitharrows_bows",
		uses = 0,
		allowed_ammunition = {
			"thinkingwitharrows_bows:arrow",
		}
	}
})

XBows:register_arrow("arrow", {
	description = S("Arrow"),
	short_description = S("Arrow"),
	inventory_image = "x_bows_arrow_wood.png",
	custom = {
		mod_name = "thinkingwitharrows_bows",
		tool_capabilities = {
			full_punch_interval = 0.7,
			max_drop_level = 0,
			damage_groups = { fleshy = 2 }
		}
	}
})


-- Add functions to add/set arrows
function thinkingwitharrows_bows.set_arrows(player, num)
	local inv = player:get_inventory()
	local stack
	if num == 0 then
		stack = ItemStack()
	else
		stack = ItemStack({name = "thinkingwitharrows_bows:arrow", count = num})
	end
	inv:set_stack("x_bows:arrow_inv", 1, stack)
	thinkingwitharrows.update_hud(player)
end

function thinkingwitharrows_bows.add_arrows(player, num, scale_with_difficulty)
	-- Easy mode
	local num = num
	if thinkingwitharrows.difficulty == 0 and scale_with_difficulty ~= false then
		num = num / 5 * 8
	end

	local inv = player:get_inventory()
	local old_stack = inv:get_stack("x_bows:arrow_inv", 1)
	local old_count = old_stack:get_count()

	local stack
	if old_count == nil and num > 0 then
		stack = ItemStack({name = "thinkingwitharrows_bows:arrow", count = num})
	else
		stack = ItemStack({name = "thinkingwitharrows_bows:arrow", count = old_count + num})
	end

	if stack then
		inv:set_stack("x_bows:arrow_inv", 1, stack)
		thinkingwitharrows.update_hud(player)
	end
end


dofile(core.get_modpath(core.get_current_modname()) .. "/nodes.lua")
dofile(core.get_modpath(core.get_current_modname()) .. "/reflectors.lua")
