--[[ init.lua
Copyright 2025 Pixelo789

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.

SPDX-License-Identifier: AGPL-3.0-or-later
--]]


local S = core.get_translator(core.get_current_modname())
register_node = core.register_node


local concrete_nodes = {
	concrete_black = S("Black Concrete"),
	--concrete_blue = S("Blue Concrete"),
	--concrete_brown = S("Brown Concrete"),
	--concrete_cyan = S("Cyan Concrete"),
	concrete_green = S("Green Concrete"),
	concrete_grey = S("Grey Concrete"),
	concrete_light_blue = S("Light Blue Concrete"),
	--concrete_lime = S("Lime Concrete"),
	--concrete_magenta = S("Magenta Concrete"),
	concrete_orange = S("Orange Concrete"),
	concrete_pink = S("Pink Concrete"),
	--concrete_red = S("Red Concrete"),
	--concrete_silver = S("Silver Concrete"),
	concrete_white = S("White Concrete"),
	--concrete_yellow = S("Yellow Concrete"),
}

for id, name in pairs(concrete_nodes) do
	register_node("thinkingwitharrows_nodes:" .. id, {
		description = name,
		tiles = {"thinkingwitharrows_nodes_" .. id .. ".png"},
		stack_max = 1000,
		groups = {oddly_breakable_by_hand = 2},
	})
end

register_node("thinkingwitharrows_nodes:light", {
	description = S("Light"),
	tiles = {"thinkingwitharrows_nodes_light.png"},
	stack_max = 1000,
	groups = {oddly_breakable_by_hand = 2},
	light_source = core.LIGHT_MAX,
	paramtype = "light",
})

register_node("thinkingwitharrows_nodes:black_box", {
	description = S("Black box for level transitions"),
	tiles = {"thinkingwitharrows_init_black_box.png"},
	stack_max = 1000,
	groups = {oddly_breakable_by_hand = 2},
})

register_node("thinkingwitharrows_nodes:mineable", {
	description = S("Mineable block"),
	tiles = {"thinkingwitharrows_nodes_mineable_block.png"},
	stack_max = 1000,
	groups = {oddly_breakable_by_hand = 3},
})


local a = "thinkingwitharrows_nodes_concrete_white.png"
local b = "thinkingwitharrows_nodes_concrete_white_slab.png"
register_node("thinkingwitharrows_nodes:concrete_white_slab", {
	description = S("White Concrete Slab"),
	drawtype = "nodebox",
	tiles = {a, a, b},
	stack_max = 1000,
	groups = {oddly_breakable_by_hand = 2},
	node_box = {
		type = "fixed",
		fixed = {-0.5, -0.5, -0.5, 0.5, 0, 0.5},
	},
})

local framed_glass = core.settings:get_bool("thinkingwitharrows_framed_glass")
local glass_drawtype = "glasslike"
local glass_tiles = {"thinkingwitharrows_nodes_glass_detail.png"}
if framed_glass == true then
	glass_drawtype = glass_drawtype .. "_framed"
	glass_tiles = {"thinkingwitharrows_nodes_glass.png", "thinkingwitharrows_nodes_glass_detail.png"}
end
register_node("thinkingwitharrows_nodes:glass", {
	description = S("Glass"),
	drawtype = glass_drawtype,
	tiles = glass_tiles,
	inventory_image = core.inventorycube("thinkingwitharrows_nodes_glass.png"),
	stack_max = 1000,
	groups = {oddly_breakable_by_hand = 2},
	paramtype = "light",
	sunlight_propagates = true,
	use_texture_alpha = "blend",
})
