

-- Copyright (C) 2020 2021 PsycoJaker

-- This file is part of UwU Mod Minetest Mod.

-- UwU Mod is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- any later version.

-- UwU Mod is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with UwU Mod.  If not, see <https://www.gnu.org/licenses/>.




local S = core.get_translator(core.get_current_modname())


-- UwU Block
core.register_node("uwu:block", {
      description = S("UwU Block"),
      tiles = {"uwu_yellow.png", "uwu_yellow.png", "uwu_yellow.png^uwu_face.png"},
      inventory_image = "uwu_yellow.png^uwu_face.png",
      is_ground_content = false,
      paramtype = "light",
      sunlight_propagates = true,
      stack_max = 64,
      groups = {pickaxey=1, handy=1, uwu=1, building_block=1},
      sounds = mcl_sounds.node_sound_glass_defaults(),
      _mcl_blast_resistance = 1,
      _mcl_hardness = 0.3,

      after_place_node = function(pos, placer, itemstack, pointed_thing)
	 uwu.add_happiness(pos, 1)
	 core.get_node_timer(pos):start(uwu.timer)
      end,
      
      on_rightclick = function(pos, node, clicker, itemstack)
	 uwu.on_rightclick(pos, node, clicker, itemstack)
      end,

      on_timer = function(pos, elapsed)
	 local meta = core.get_meta(pos)
	 local happiness = meta:get_int("happiness")
	 if happiness >= uwu.growhappiness then
	    uwu.grow(pos)
	 else
	    uwu.add_happiness(pos, -1, 5)
	    uwu.say_uwu(pos, 20)
	    uwu.walk(pos)
	 end
	 core.get_node_timer(pos):start(uwu.timer)
      end,
})

local lituwubox = {
   type = "fixed",
   fixed = {
      {-4/16, -8/16, -4/16, 4/16, 0/16, 4/16}
   }
}

-- Little UwU
core.register_node("uwu:little", {
      description = S("Little UwU Block"),
      drawtype = "nodebox",
      tiles = {"uwu_yellow.png", "uwu_yellow.png", "uwu_yellow.png^uwu_little_face.png"},
      is_ground_content = false,
      paramtype = "light",
      sunlight_propagates = true,
      selection_box = lituwubox,
      node_box = lituwubox,
      stack_max = 64,
      groups = {pickaxey=1, handy=1, uwu=1, building_block=1},
      sounds = mcl_sounds.node_sound_glass_defaults(),
      _mcl_blast_resistance = 1,
      _mcl_hardness = 0.3,

      after_place_node = function(pos, placer, itemstack, pointed_thing)
	 uwu.add_happiness(pos, 1)
	 core.get_node_timer(pos):start(uwu.timer)
      end,
      
      on_rightclick = function(pos, node, clicker, itemstack)
	 uwu.on_rightclick(pos, node, clicker, itemstack)
      end,
      
      on_timer = function(pos, elapsed)
	 local meta = core.get_meta(pos)
	 local happiness = meta:get_int("happiness")
	 if happiness >= uwu.growhappiness then
	    uwu.grow(pos)
	 else
	    uwu.add_happiness(pos, -1, 5)
	    uwu.say_uwu(pos, 20)
	    uwu.walk(pos)
	 end
	 core.get_node_timer(pos):start(uwu.timer)
      end,

      on_punch = function(pos, node, puncher, pointed_thing)
	 uwu.walk(pos)
      end
      
})



-- UwU ore
core.register_node("uwu:ore", {
      description = S("UwU Ore"),
      tiles = {"default_stone.png^uwu_ore.png"},
      is_ground_content = true,
      light_source = 4,
      drop = "uwu:crystal",
      stack_max = 64,
      groups = {pickaxey=4, building_block=1, material_stone=1, xp=4, blast_furnace_smeltable=1},
      sounds = mcl_sounds.node_sound_stone_defaults(),
      _mcl_blast_resistance = 3,
      _mcl_hardness = 3,
      _mcl_silk_touch_drop = true,
      _mcl_fortune_drop = mcl_core.fortune_drop_ore,
})


-- UwU Crystal
core.register_node("uwu:crystal", {
      description = S("UwU Crystal"),
      tiles = {"uwu_crystal.png"},
      paramtype = "light",
      paramtype2 = "wallmounted",
      use_texture_alpha = "clip",
      drawtype = "plantlike",
      light_source = 8,
      is_ground_content = true,
      sunlight_propagates = true,
      walkable = false,
      stack_max = 64,
      inventory_image = "uwu_crystal.png",
      wield_image = "uwu_crystal.png",
      selection_box = {
	 type = "fixed",
	 fixed = {-4/16, -8/16, -4/16, 4/16, 5/16, 4/16},
      },
      groups = {pickaxey=1, handy=1, uwu=1, deco_block=1, destroy_by_lava_flow = 1, attached_node = 1, dig_by_piston = 1,},
      sounds = mcl_sounds.node_sound_glass_defaults(),
      _mcl_hardness = 0.3,
      _mcl_blast_resistance = 2,
})
