

-- Copyright (C) 2020 2023 PsycoJaker

-- This file is part of UwU Mod Minetest Mod.

-- UwU Mod is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- any later version.

-- UwU Mod is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with UwU Mod.  If not, see <https://www.gnu.org/licenses/>.



-----------------UWU-----------------

local modpath = core.get_modpath(core.get_current_modname())

dofile(modpath .. "/tools.lua")
dofile(modpath .. "/crafts.lua")
dofile(modpath .. "/functions.lua")
dofile(modpath .. "/nodes.lua")
dofile(modpath .. "/entity.lua")


-- UwU Gen
local stonelike = {"mcl_core:stone", "mcl_core:diorite", "mcl_core:andesite", "mcl_core:granite"}

-- Common spawn
core.register_ore({
      ore_type       = "scatter",
      ore            = "uwu:ore",
      wherein         = stonelike,
      clust_scarcity = 10000,
      clust_num_ores = 4,
      clust_size     = 3,
      y_min          = mcl_vars.mg_overworld_min,
      y_max          = mcl_worlds.layer_to_y(12),
})
core.register_ore({
      ore_type       = "scatter",
      ore            = "uwu:ore",
      wherein         = stonelike,
      clust_scarcity = 5000,
      clust_num_ores = 2,
      clust_size     = 2,
      y_min          = mcl_vars.mg_overworld_min,
      y_max          = mcl_worlds.layer_to_y(12),
})
core.register_ore({
      ore_type       = "scatter",
      ore            = "uwu:ore",
      wherein         = stonelike,
      clust_scarcity = 10000,
      clust_num_ores = 8,
      clust_size     = 3,
      y_min          = mcl_vars.mg_overworld_min,
      y_max          = mcl_worlds.layer_to_y(12),
})

-- Rare spawn
core.register_ore({
      ore_type       = "scatter",
      ore            = "uwu:ore",
      wherein         = stonelike,
      clust_scarcity = 20000,
      clust_num_ores = 1,
      clust_size     = 1,
      y_min          = mcl_worlds.layer_to_y(13),
      y_max          = mcl_worlds.layer_to_y(15),
})
core.register_ore({
      ore_type       = "scatter",
      ore            = "uwu:ore",
      wherein         = stonelike,
      clust_scarcity = 20000,
      clust_num_ores = 2,
      clust_size     = 2,
      y_min          = mcl_worlds.layer_to_y(13),
      y_max          = mcl_worlds.layer_to_y(15),
})


-- old alias
core.register_alias("uwu:espadita_uwu", "uwu:sword")
core.register_alias("uwu:piquito_uwu", "uwu:pick")
core.register_alias("uwu:hachita_uwu", "uwu:axe")
core.register_alias("uwu:palita_uwu", "uwu:shovel")
core.register_alias("uwu:bloque_uwu", "uwu:block")
core.register_alias("uwu:cristalcito_uwu", "uwu:crystal")
core.register_alias("uwu:stone_with_uwu", "uwu:ore")
