

-- Copyright (C) 2020 2021 PsycoJaker

-- This file is part of UwU Mod Minetest Mod.

-- UwU Mod is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- any later version.

-- UwU Mod is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with UwU Mod.  If not, see <https://www.gnu.org/licenses/>.



local modname = core.get_current_modname()
local modpath = core.get_modpath(modname)
local S = core.get_translator(modname)
local wield_scale = mcl_vars.tool_wield_scale


local function make_grass_path(itemstack, placer, pointed_thing)
   -- Use pointed node's on_rightclick function first, if present
   local node = core.get_node(pointed_thing.under)
   if placer and not placer:get_player_control().sneak then
      if core.registered_nodes[node.name] and core.registered_nodes[node.name].on_rightclick then
	 return core.registered_nodes[node.name].on_rightclick(pointed_thing.under, node, placer, itemstack) or itemstack
      end
   end

   -- Only make grass path if tool used on side or top of target node
   if pointed_thing.above.y < pointed_thing.under.y then
      return itemstack
   end
   
   if (core.get_item_group(node.name, "grass_block") == 1) then
      local above = table.copy(pointed_thing.under)
      above.y = above.y + 1
      if core.get_node(above).name == "air" then
	 if core.is_protected(pointed_thing.under, placer:get_player_name()) then
	    core.record_protection_violation(pointed_thing.under, placer:get_player_name())
	    return itemstack
	 end
	 
	 if not core.is_creative_enabled(placer:get_player_name()) then
	    -- Add wear (as if digging a shovely node)
	    local toolname = itemstack:get_name()
	    local wear = mcl_autogroup.get_wear(toolname, "shovely")
	    itemstack:add_wear(wear)
	 end
	 core.sound_play({name="default_grass_footstep", gain=1}, {pos = above}, true)
	 core.swap_node(pointed_thing.under, {name="mcl_core:grass_path"})
      end
   end
   return itemstack
end


local function make_stripped_trunk(itemstack, placer, pointed_thing)
   if pointed_thing.type ~= "node" then return end
   
   local node = core.get_node(pointed_thing.under)
   local noddef = core.registered_nodes[core.get_node(pointed_thing.under).name]
   
   if not placer:get_player_control().sneak and noddef.on_rightclick then
      return core.item_place(itemstack, placer, pointed_thing)
   end
   if core.is_protected(pointed_thing.under, placer:get_player_name()) then
      core.record_protection_violation(pointed_thing.under, placer:get_player_name())
      return itemstack
   end
   
   if noddef._mcl_stripped_variant == nil then
      return itemstack
   else
      core.swap_node(pointed_thing.under, {name=noddef._mcl_stripped_variant, param2=node.param2})
      if not core.is_creative_enabled(placer:get_player_name()) then
	 -- Add wear (as if digging a axey node)
	 local toolname = itemstack:get_name()
	 local wear = mcl_autogroup.get_wear(toolname, "axey")
	 itemstack:add_wear(wear)
      end
   end
   return itemstack
end



-- uwu tools

core.register_tool("uwu:sword", {
      description = S("UwU Sword"),
      inventory_image = "uwu_sword.png",
      wield_scale = wield_scale,
      groups = { weapon=1, sword=1, dig_speed_class=6, enchantability=22 },
      tool_capabilities = {
	 full_punch_interval = 0.625,
	 max_drop_level=2,
	 damage_groups = {fleshy=4},
	 punch_attack_uses = 33,
      },
      sound = { breaks = "default_tool_breaks" },
      _repair_material = "uwu:crystal",
      _mcl_toollike_wield = true,
      _mcl_diggroups = {
	 swordy = { speed = 12, level = 4, uses = 800 },
	 swordy_cobweb = { speed = 12, level = 4, uses = 250 }
      },
})

core.register_tool("uwu:pick", {
      description = S("UwU Pickaxe"),
      inventory_image = "uwu_pick.png",
      wield_scale = wield_scale,
      groups = { tool=1, pickaxe=1, dig_speed_class=6, enchantability=22 },
      tool_capabilities = {
	 full_punch_interval = 0.83333333,
	 max_drop_level=2,
	 damage_groups = {fleshy=2},
	 punch_attack_uses = 17,
      },
      sound = { breaks = "default_tool_breaks" },
      _repair_material = "uwu:crystal",
      _mcl_toollike_wield = true,
      _mcl_diggroups = {
	 pickaxey = { speed = 12, level = 5, uses = 250 }
      },
})

core.register_tool("uwu:axe", {
      description = S("UwU Axe"),
      inventory_image = "uwu_axe.png",
      wield_scale = wield_scale,
      groups = { tool=1, axe=1, dig_speed_class=6, enchantability=22 },
      tool_capabilities = {
	 full_punch_interval = 1.0,
	 max_drop_level=2,
	 damage_groups = {fleshy=7},
	 punch_attack_uses = 17,
      },
      on_place = make_stripped_trunk,
      sound = { breaks = "default_tool_breaks" },
      _repair_material = "uwu:crystal",
      _mcl_toollike_wield = true,
      _mcl_diggroups = {
	 axey = { speed = 12, level = 4, uses = 250 }
      },
})

core.register_tool("uwu:shovel", {
      description = S("UwU Shovel"),
      inventory_image = "uwu_shovel.png",
      wield_image = "uwu_shovel.png^[transformR90",
      wield_scale = wield_scale,
      groups = { tool=1, shovel=1, dig_speed_class=6, enchantability=22 },
      tool_capabilities = {
	 full_punch_interval = 1,
	 max_drop_level=2,
	 damage_groups = {fleshy=2},
	 punch_attack_uses = 17,
      },
      on_place = make_grass_path,
      sound = { breaks = "default_tool_breaks" },
      _repair_material = "uwu:crystal",
      _mcl_toollike_wield = true,
      _mcl_diggroups = {
	 shovely = { speed = 12, level = 4, uses = 250 }
      },
})
