

-- Copyright (C) 2020 2021 PsycoJaker

-- This file is part of UwU Mod Minetest Mod.

-- UwU Mod is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- any later version.

-- UwU Mod is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with UwU Mod.  If not, see <https://www.gnu.org/licenses/>.



-----------------UWU-----------------

local S = core.get_translator(core.get_current_modname())
local uwu_spawn = core.settings:get_bool("uwu.entity_spawn") ~= false

local uwu_big = {
   description = S("UwU"),
   type = "animal",
   spawn_class = "passive",
   can_despawn = true, 
   hp_min = 16,
   hp_max = 16,
   xp_min = 4,
   xp_max = 4,
   collisionbox = {-1.02, -0.01, -1.02, 1.02, 2.03, 1.02},
   visual_size = {x=12.5, y=12.5},
   textures = {{ "uwu_entity.png", "uwu_entity.png" }},
   visual = "mesh",
   mesh = "mobs_mc_magmacube.b3d",
   makes_footstep_sound = true,
   sounds = {
      jump = "",
      death = "mobs_mc_magma_cube_big",
      attack = "uwu",
      distance = 16,
      base_pitch = 0.65,
   },
   walk_velocity = 2.5,
   run_velocity = 2.5,
   damage = 6,
   reach = 3,
   armor = 53,
   drops = {},
   -- TODO: Fix animations
   animation = {
      jump_speed = 20,
      stand_speed = 20,
      walk_speed = 20,
      jump_start = 1,
      jump_end = 40,
      stand_start = 1,
      stand_end = 1,
      walk_start = 1,
      walk_end = 40,
   },
   follow = {
      "uwu:crystal",
   },
   pick_up = {"uwu:crystal"},
   on_pick_up = uwu.entity_on_pickup,
   water_damage = 0,
   lava_damage = 1,
   fire_damage = 1,
   light_damage = 0,
   fall_damage = 0,
   view_range = 16,
   attack_type = "dogfight",
   passive = false,
   jump = true,
   jump_height = 8,
   walk_chance = 0,
   fear_height = 5,
   spawn_small_alternative = "uwu:uwu_small",
   on_die = uwu.spawn_children_on_die("uwu:uwu_small", 0.8, 1.5),
   fire_resistant = false,
   attacks_monsters = true,
   attack_animals = false,
}
mcl_mobs.register_mob("uwu:uwu_big", uwu_big)

local uwu_small = table.copy(uwu_big)
uwu_small.sounds.jump = ""
uwu_small.sounds.death = "mobs_mc_magma_cube_small"
uwu_small.sounds.base_pitch = 1
uwu_small.hp_min = 4
uwu_small.hp_max = 4
uwu_small.xp_min = 2
uwu_small.xp_max = 2
uwu_small.collisionbox = {-0.51, -0.01, -0.51, 0.51, 1.00, 0.51}
uwu_small.visual_size = {x=6.25, y=6.25}
uwu_small.reach = 2.75
uwu_small.walk_velocity = .8
uwu_small.run_velocity = 2.0
uwu_small.jump_height = 6
uwu_small.damage = 1
uwu_small.reach = 2.75
uwu_small.armor = 66
uwu_small.spawn_small_alternative = "uwu:uwu_tiny"
uwu_small.on_die = uwu.spawn_children_on_die("uwu:uwu_tiny", 0.6, 1.0)
mcl_mobs.register_mob("uwu:uwu_small", uwu_small)

local uwu_tiny = table.copy(uwu_big)
uwu_tiny.sounds.jump = ""
uwu_tiny.sounds.death = "mobs_mc_magma_cube_small"
uwu_tiny.sounds.base_pitch = 1.25
uwu_tiny.hp_min = 1
uwu_tiny.hp_max = 1
uwu_tiny.xp_min = 1
uwu_tiny.xp_max = 1
uwu_tiny.collisionbox = {-0.2505, -0.01, -0.2505, 0.2505, 0.50, 0.2505}
uwu_tiny.visual_size = {x=3.125, y=3.125}
uwu_tiny.walk_velocity = 1.02
uwu_tiny.run_velocity = 1.02
uwu_tiny.jump_height = 4
uwu_tiny.damage = 0
uwu_tiny.reach = 2.5
uwu_tiny.armor = 50
uwu_tiny.drops = {
   {name = "uwu:crystal",
    chance = 4,
    min = 1,
    max = 1,},
}
uwu_tiny.pick_up = nil
uwu_tiny.on_pick_up = nil
uwu_tiny.spawn_small_alternative = nil
uwu_tiny.on_die = nil
uwu_tiny.attacks_monsters = false

mcl_mobs.register_mob("uwu:uwu_tiny", uwu_tiny)


local cave_biomes = {
	"FlowerForest_underground",
	"JungleEdge_underground",
	"StoneBeach_underground",
	"MesaBryce_underground",
	"Mesa_underground",
	"RoofedForest_underground",
	"Jungle_underground",
	"Swampland_underground",
	"BirchForest_underground",
	"Plains_underground",
	"MesaPlateauF_underground",
	"ExtremeHills_underground",
	"MegaSpruceTaiga_underground",
	"BirchForestM_underground",
	"SavannaM_underground",
	"MesaPlateauFM_underground",
	"Desert_underground",
	"Savanna_underground",
	"Forest_underground",
	"SunflowerPlains_underground",
	"ColdTaiga_underground",
	"IcePlains_underground",
	"IcePlainsSpikes_underground",
	"MegaTaiga_underground",
	"Taiga_underground",
	"ExtremeHills+_underground",
	"JungleM_underground",
	"ExtremeHillsM_underground",
	"JungleEdgeM_underground",
	"MangroveSwamp_underground"
}


local water_level = mobs_mc.water_level
local cave_min = mcl_vars.mg_overworld_min
local cave_max = water_level - 23
local light_level = 7 --minetest.LIGHT_MAX+1

if uwu_spawn then
	mcl_mobs:spawn_specific(
		"uwu:uwu_tiny",
		"overworld",
		"ground",
		cave_biomes,
		0,
		light_level,
		30, -- interval
		35000, -- chance
		1, -- count
		cave_min,
		cave_max)
	
	mcl_mobs:spawn_specific(
		"uwu:uwu_small",
		"overworld",
		"ground",
		cave_biomes,
		0,
		light_level,
		30, -- interval
		85000, -- chance
		1, -- count
		cave_min,
		cave_max)
	
	mcl_mobs:spawn_specific(
		"uwu:uwu_big",
		"overworld",
		"ground",
		cave_biomes,
		0,
		light_level,
		30, -- interval
		55000, -- chance
		1, -- count
		cave_min,
		cave_max)
end

mcl_mobs.register_egg("uwu:uwu_tiny", S("UwU tiny"), "#FEE41A", "#ED5FF9")
mcl_mobs.register_egg("uwu:uwu_small", S("UwU small"), "#FEE41A", "#ED5FF9")
mcl_mobs.register_egg("uwu:uwu_big", S("UwU Big"), "#FEE41A", "#ED5FF9")
