

-- Copyright (C) 2020 2024 PsycoJaker

-- This file is part of UwU Minetest Mod.

-- UwU Mod is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.

-- UwU Mod is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.

-- You should have received a copy of the GNU Affero General Public License
-- along with UwU Mod.  If not, see <https://www.gnu.org/licenses/>.


local stonelike = {"mcl_amethyst:amethyst_block", "mcl_amethyst:calcite", "mcl_amethyst:basalt_smooth"}

-- Common spawn
core.register_ore({
	ore_type       = "scatter",
	ore            = "uwu:ore",
	wherein         = stonelike,
	clust_scarcity = 10000,
	clust_num_ores = 4,
	clust_size     = 3,
	y_min          = mcl_vars.mg_overworld_min,
	y_max          = mcl_worlds.layer_to_y(12),
})
core.register_ore({
	ore_type       = "scatter",
	ore            = "uwu:ore",
	wherein         = stonelike,
	clust_scarcity = 5000,
	clust_num_ores = 2,
	clust_size     = 2,
	y_min          = mcl_vars.mg_overworld_min,
	y_max          = mcl_worlds.layer_to_y(12),
})
core.register_ore({
	ore_type       = "scatter",
	ore            = "uwu:ore",
	wherein         = stonelike,
	clust_scarcity = 10000,
	clust_num_ores = 8,
	clust_size     = 3,
	y_min          = mcl_vars.mg_overworld_min,
	y_max          = mcl_worlds.layer_to_y(12),
})

local all_directions = {
	vector.new(1, 0, 0),
	vector.new(0, 1, 0),
	vector.new(0, 0, 1),
	vector.new(-1, 0, 0),
	vector.new(0, -1, 0),
	vector.new(0, 0, -1),
}

minetest.register_abm({
	label = "Spawn UwU crystal",
	nodenames = {"mcl_amethyst:budding_amethyst_block", "uwu:ore"},
	neighbors = {"air", "group:water"},
	interval = 35,
	chance = 3,
	action = function(pos)
		local check_pos = vector.add(all_directions[math.random(1, #all_directions)], pos)
		local check_node = minetest.get_node(check_pos)
		local check_node_name = check_node.name
		if check_node_name ~= "air" and minetest.get_item_group(check_node_name, "water") == 0 then return end
		local param2 = minetest.dir_to_wallmounted(vector.subtract(pos, check_pos))
		local new_node = {name = "uwu:crystal", param2 = param2}
		minetest.swap_node(check_pos, new_node)
		if core.get_node(pos) and core.get_node(pos).name == "uwu:ore" then
			core.swap_node(pos, {name = "mcl_core:stone"})
		end
	end,
})
