

-- Copyright (C) 2020 2026 PsycoJaker

-- This file is part of UwU Minetest Mod.

-- UwU Mod is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.

-- UwU Mod is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.

-- You should have received a copy of the GNU Affero General Public License
-- along with UwU Mod.  If not, see <https://www.gnu.org/licenses/>.



local S = core.get_translator(core.get_current_modname())

mcl_tools.register_set("uwu", {
	craftable = true,
	material = "uwu:crystal",
	uses = 200,
	level = 4,
	speed = 12,
	max_drop_level = 2,
	groups = { dig_speed_class = 6, enchantability = 20 }
}, {
	["pick"] = {
		description = S("UwU Pickaxe"),
		inventory_image = "uwu_pick.png",
		tool_capabilities = {
			full_punch_interval = 0.83333333,
			damage_groups = { fleshy = 2 }
		}
	},
	["shovel"] = {
		description = S("UwU Shovel"),
		inventory_image = "uwu_shovel.png",
		tool_capabilities = {
			full_punch_interval = 1,
			damage_groups = { fleshy = 2 }
		}
	},
	["sword"] = {
		description = S("UwU Sword"),
		inventory_image = "uwu_sword.png",
		tool_capabilities = {
			full_punch_interval = 0.625,
			damage_groups = { fleshy = 4 }
		}
	},
	["axe"] = {
		description = S("UwU Axe"),
		inventory_image = "uwu_axe.png",
		tool_capabilities = {
			full_punch_interval = 1,
			damage_groups = { fleshy = 7 }
		}
	}
})-- { _mcl_cooking_output = "uwu:crystal" })


core.register_alias("uwu:pick", "uwu:pick_uwu")
core.register_alias("uwu:axe", "uwu:axe_uwu")
core.register_alias("uwu:shovel", "uwu:shovel_uwu")
core.register_alias("uwu:sword", "uwu:sword_uwu")
