
local S = minetest.get_translator(minetest.get_current_modname())

-- Herramientitas uwu

minetest.register_tool("uwu:espadita_uwu", {
	description = S("Espadita UwU"),
	inventory_image = "uwu_espadita.png",
	tool_capabilities = {
		full_punch_interval = 0.7,
		max_drop_level=1,
		groupcaps={
			snappy={times={[1]=2.0, [2]=1.00, [3]=0.35}, uses=30, maxlevel=3},
		},
		damage_groups = {fleshy=7},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {sword = 1}
})

minetest.register_tool("uwu:piquito_uwu", {
	description = S("Piquito UwU"),
	inventory_image = "uwu_piquito.png",
	tool_capabilities = {
		full_punch_interval = 1.0,
		max_drop_level=2,
		groupcaps={
			cracky={times={[1]=4.00, [2]=1.60, [3]=0.80}, uses=29, maxlevel=3},
		},
		damage_groups = {fleshy=4},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {pickaxe = 1}
})

minetest.register_tool("uwu:hachita_uwu", {
	description = S("Hachita UwU"),
	inventory_image = "uwu_hachita.png",
	tool_capabilities = {
		full_punch_interval = 1.2,
		max_drop_level=2,
		groupcaps={
			choppy={times={[1]=2.50, [2]=1.40, [3]=1.00}, uses=25, maxlevel=3},
		},
		damage_groups = {fleshy=6},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {axe = 1}
})

minetest.register_tool("uwu:palita_uwu", {
	description = S("Palita UwU"),
	inventory_image = "uwu_palita.png",
	wield_image = "uwu_palita.png^[transformR90",
	tool_capabilities = {
		full_punch_interval = 1.1,
		max_drop_level=2,
		groupcaps={
			crumbly={times={[1]=1.40, [2]=0.50, [3]=0.30}, uses=30, maxlevel=3},
		},
		damage_groups = {fleshy=3},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {shovel = 1}
})

