

local S = minetest.get_translator(minetest.get_current_modname())


-- UwU Bloque
minetest.register_node("uwu:bloque_uwu", {
			  description = S("Bloque UwU"),
			  tiles = {"uwu_bloque.png"},
			  is_ground_content = false,
			  groups = {cracky = 3, oddly_breakable_by_hand = 2},
			  sounds = default.node_sound_glass_defaults(),
			  
			  on_rightclick = function(pos, node, clicker, itemstack)
			     local item_manito = clicker:get_wielded_item()
			     local item_name = item_manito:get_name()
			     local es_pan = minetest.get_item_group(item_name, "food_bread")
			     
			     if es_pan == 1 then
				itemstack:take_item()	
			     else	
				minetest.sound_play("decir_uwu", {
						       pos = pos,
						       max_hear_distance = 20,
				})
			     end
			  end
})

-- UwU Mena
minetest.register_node("uwu:stone_with_uwu", {
			  description = S("Mena UwU"),
			  tiles = {"default_stone.png^uwu_mena.png"},
			  is_ground_content = true,
			  light_source = 2,
			  groups = {cracky = 1, level = 1},
			  drop = {
			     max_items = 3,
			     items = {
				{
				   items = {'uwu:cristalcito_uwu'},
				},
				{
				   items = {'uwu:cristalcito_uwu'},
				   rarity = 40,
				},
				{
				   items = {'uwu:cristalcito_uwu'},
				   rarity = 65,
				},
			     }
			  },
			  sounds = default.node_sound_glass_defaults()
})


-- UwU Cristalcito
minetest.register_node("uwu:cristalcito_uwu", {
			  description = S("Cristalcito UwU"),
			  drawtype = "plantlike",
			  light_source = 3,
			  tiles = {"uwu_cristalcitos.png"},
			  inventory_image = "uwu_cristalcitos.png",
			  wield_image = "uwu_cristalcitos.png",
			  sunlight_propagates = true,
			  paramtype = "light",
			  walkable = false,
			  groups = {cracky = 3, attached_node = 1},
			  sounds = default.node_sound_glass_defaults(),
			  selection_box = {
			     type = "fixed",
			     fixed = {-4/16, -8/16, -4/16, 4/16, 5/16, 4/16},
			  }
})
