PyuTestCore.make_wood = function (id, desc, ltiles, btiles)
  PyuTestCore.make_building_blocks(id.."_log", desc .. " Log", ltiles, nil, {
    block = PyuTestCore.BLOCK_BREAKABLE_CHOPPY,
    acid_vulnerable = 1,
    flammable = 1,
    fuel = 1
  }, {
    is_ground_content = false
  })

  PyuTestCore.make_building_blocks(id.."_wood", desc .. " Wood", btiles, nil, {
    block = PyuTestCore.BLOCK_BREAKABLE_CHOPPY,
    acid_vulnerable = 1,
    flammable = 1,
    fuel = 1
  }, {
    is_ground_content = false
  })

  local log_id = id.."_log_block"
  local wood_id = id.."_wood_block"

  minetest.override_item(log_id, {
    groups = PyuTestCore.util.tableconcat(minetest.registered_nodes[log_id].groups, {
      wooden_log = 1
    })
  })

  minetest.override_item(wood_id, {
    groups = PyuTestCore.util.tableconcat(minetest.registered_nodes[wood_id].groups, {
      wooden_planks = 1
    })
  })

  minetest.register_craft({
    output = id.."_wood_block 4",
    recipe = {id.."_log_block"},
    type = "shapeless"
  })
end

PyuTestCore.make_wood("pyutest_core:wooden", "Oak", {
  "log-top-bottom.png",
  "log-top-bottom.png",
  "log.png"
}, {
  "wood.png"
})

PyuTestCore.make_wood("pyutest_core:savanna", "Savanna", {
  "savanna-log-top-bottom.png",
  "savanna-log-top-bottom.png",
  "savanna-log.png"
}, {
  "savanna-wood.png"
})

PyuTestCore.make_wood("pyutest_core:birch", "Birch", {
  "birch-log-top-bottom.png",
  "birch-log-top-bottom.png",
  "birch-log.png"
}, {
  "birch-wood.png"
})

PyuTestCore.make_wood("pyutest_core:cherry", "Cherry", {
  "cherry-log-top-bottom.png",
  "cherry-log-top-bottom.png",
  "cherry-log.png"
}, {
  "cherry-wood.png"
})

PyuTestCore.make_wood("pyutest_core:redwood", "Redwood", {
  "redwood-log-top-bottom.png",
  "redwood-log-top-bottom.png",
  "redwood-log.png"
}, {
  "redwood.png"
})

PyuTestCore.make_wood("pyutest_core:jungle", "Jungle", {
  "jungle-log-top-bottom.png",
  "jungle-log-top-bottom.png",
  "jungle-log.png"
}, {
  "jungle-wood.png"
})
