minetest.register_privilege("fun", {
  description = "Access to for fun commands",
  give_to_singeplayer = true
})

minetest.register_chatcommand("explode", {
  params = "<range>",
  description = "Create an explosion of size RANGE.",
  privs = {
    fun = true
  },
  func = function(name, param)
    local player = minetest.get_player_by_name(name)
    local range = tonumber(param)

    if range == nil then
      return false, "Please use a number for the range."
    end
    
    PyuTestCore.create_explosion(player:get_pos(), range, false, range,  player, true)
  end
})
