PyuTestMapgen.register_structure("igloo", "igloo", {
  place_on = {"pyutest_core:snow_block"},
  fill_ratio = 0.00004,
  biomes = {"frozen_plains"},
  y_max = PyuTestCore_BiomeTops.frozen_plains,
  y_min = 1,
  schematic = PyuTestCore.get_schem_path("igloo"),
  rotation = "random",
  flags = "place_center_x, place_center_z",
  place_offset_y = 1
})

PyuTestMapgen.register_structure("desertwell", "desertwell", {
  place_on = {"pyutest_core:sand_block"},
  fill_ratio = 0.00006,
  biomes = {"desert"},
  y_max = PyuTestCore_BiomeTops.desert,
  y_min = 1,
  rotation = "random"
})

minetest.register_decoration({
  deco_type = "simple",
  sidelen = 16,
  fill_ratio = 0.0003,
  place_on = {"group:ground"},
  biomes = minetest.registered_biomes,
  y_max = PyuTestCore_BiomeTops.mountains,
  y_min = PyuTestCore_SurfaceBottom,
  decoration = {
    "pyutest_core:trash_lootbox",
    "pyutest_core:resource_lootbox",
    "pyutest_core:griefer_lootbox",
    "pyutest_core:liquid_sources_lootbox",
    "pyutest_core:lighting_lootbox",
  }
})

PyuTestMapgen.register_structure("ice_spike", "icespike", {
  fill_ratio = 0.0008,
  place_on = {
    "pyutest_core:ice_block",
    "pyutest_core:stone_block"
  },
  biomes = {
    "ice_spikes",
    "ice_spikes_ocean",
    "ice_spikes_cave"
  },
  y_max = PyuTestCore_BiomeTops.ice_spikes,
  y_min = PyuTestCore_WorldBottom,
  -- place_offset_y = -1,
  spawn_by = {"air"},
  num_spawn_by = 2
})

PyuTestMapgen.register_structure("obsidian_mound", "obsidian-mound", {
  fill_ratio = 0.0001,
  place_on = {"pyutest_core:mycelium_block"},
  biomes = {
    "mushroom_fields"
  },
  y_max = PyuTestCore_BiomeTops.mushroom_fields,
  y_min = PyuTestCore_SurfaceBottom,
})

PyuTestMapgen.register_structure("ocean_ruins", "ocean_ruins", {
  fill_ratio = 0.0002,
  place_on = {"pyutest_core:gravel_block"},
  biomes = PyuTestCore.get_biomes_from_type(PyuTestCore.BIOME_TYPES.OCEAN),
  y_max = PyuTestCore_DeepOceanMax + 4,
  y_min = PyuTestCore_DeepOceanMin,
  spawn_by = {"pyutest_core:water_source"},
  num_spawn_by = 2
})
