PyuTestCore.make_tool = function (nsname, desc, groups, wield_image, extra_conf)
  local conf = {
    description = Translate(desc),
    wield_image = wield_image,
    inventory_image = wield_image,
    groups = PyuTestCore.util.tableconcat(groups, {
      tool = 1
    })
  }

  if extra_conf ~= nil then
    for k, v in pairs(extra_conf) do
      conf[k] = v
    end
  end

  minetest.register_tool(nsname, conf)
end

PyuTestCore.make_food = function (nsname, desc, wield_image, health_fill, extra_code)
  local code = extra_code or function()end

  PyuTestCore.make_item(nsname, desc, {}, wield_image, {
    on_use = function (itemstack, user, pt)
      if user == nil then return end
      minetest.sound_play({name = "eat", gain = 1}, {pos = user:get_pos(), start_time = 1.2})
      minetest.do_item_eat(health_fill, "", itemstack, user, pt)
      code()
    end
  })
end

PyuTestCore.make_tool("pyutest_core:wooden_pickaxe", "Wooden Pickaxe", {}, "wooden-pickaxe.png", {
  stack_max = 1,
  tool_capabilities = {
    groupcaps = {
      block = {
        times = {
          [PyuTestCore.BLOCK_BREAKABLE_INSTANT] = 0.085,
          [PyuTestCore.BLOCK_BREAKABLE_NORMAL] = 0.75,
          [PyuTestCore.BLOCK_BREAKABLE_CHOPPY] = 1.3,
          [PyuTestCore.BLOCK_BREAKABLE_MIDDLE] = 2.4,
        },
        uses = 200,
      }
    },
    punch_attack_uses = 100,
    damage_groups = {fleshy = 3}
  }
})

PyuTestCore.make_tool("pyutest_core:stone_pickaxe", "Stone Pickaxe", {}, "stone-pickaxe.png", {
  stack_max = 1,
  tool_capabilities = {
    groupcaps = {
      block = {
        times = {
          [PyuTestCore.BLOCK_BREAKABLE_INSTANT] = 0.065,
          [PyuTestCore.BLOCK_BREAKABLE_NORMAL] = 0.55,
          [PyuTestCore.BLOCK_BREAKABLE_CHOPPY] = 0.9,
          [PyuTestCore.BLOCK_BREAKABLE_MIDDLE] = 1.7,
          [PyuTestCore.BLOCK_BREAKABLE_LONG] = 2.2,
          [PyuTestCore.BLOCK_BREAKABLE_VERYLONG] = 9,
          [PyuTestCore.BLOCK_BREAKABLE_FOREVER] = 15
        },
        uses = 450,
      }
    },
    punch_attack_uses = 225,
    damage_groups = {fleshy = 3}
  }
})

PyuTestCore.make_tool("pyutest_core:iron_pickaxe", "Iron Pickaxe", {}, "iron-pickaxe.png", {
  stack_max = 1,
  tool_capabilities = {
    groupcaps = {
      block = {
        times = {
          [PyuTestCore.BLOCK_BREAKABLE_INSTANT] = 0.035,
          [PyuTestCore.BLOCK_BREAKABLE_NORMAL] = 0.35,
          [PyuTestCore.BLOCK_BREAKABLE_CHOPPY] = 0.7,
          [PyuTestCore.BLOCK_BREAKABLE_MIDDLE] = 0.7,
          [PyuTestCore.BLOCK_BREAKABLE_LONG] = 1.9,
          [PyuTestCore.BLOCK_BREAKABLE_VERYLONG] = 7,
          [PyuTestCore.BLOCK_BREAKABLE_FOREVER] = 13
        },
        uses = 750,
      }
    },
    punch_attack_uses = 375,
    damage_groups = {fleshy = 4}
  }
})

PyuTestCore.make_tool("pyutest_core:diamond_pickaxe", "Diamond Pickaxe", {}, "diamond-pickaxe.png", {
  stack_max = 1,
  tool_capabilities = {
    groupcaps = {
      block = {
        times = {
          [PyuTestCore.BLOCK_BREAKABLE_INSTANT] = 0.035,
          [PyuTestCore.BLOCK_BREAKABLE_NORMAL] = 0.35,
          [PyuTestCore.BLOCK_BREAKABLE_CHOPPY] = 0.6,
          [PyuTestCore.BLOCK_BREAKABLE_MIDDLE] = 0.6,
          [PyuTestCore.BLOCK_BREAKABLE_LONG] = 1.9,
          [PyuTestCore.BLOCK_BREAKABLE_VERYLONG] = 5,
          [PyuTestCore.BLOCK_BREAKABLE_FOREVER] = 8
        },
        uses = 1200,
      }
    },
    punch_attack_uses = 600,
    damage_groups = {fleshy = 4}
  }
})

PyuTestCore.make_item("pyutest_core:bomb", "Bomb", {}, "bomb.png", {
  stack_max = 16,
  on_use = function (_, user)
    if user == nil then
      return
    end
    local pos = user:get_pos()
    PyuTestCore.create_explosion(pos, 2, false, 3, user)
    local stack = user:get_wielded_item()
    stack:set_count(stack:get_count() - 1)

    user:set_wielded_item(stack)
  end
})

PyuTestCore.make_item("pyutest_core:windball", "Windball", {}, "windball.png", {
  stack_max = 16,
  on_use = function (_, user)
    if user == nil then
      return
    end


    local pos = user:get_pos()
    minetest.sound_play({name = "spellbook_action", gain = 0.75}, {pos = pos})
    math.randomseed(os.time())
    user:add_velocity({
        x = 0,
        z = 0,
        y = math.random(12, 22)
    })


    local stack = user:get_wielded_item()
    stack:set_count(stack:get_count() - 1)

    user:set_wielded_item(stack)
  end
})


PyuTestCore.make_food("pyutest_core:apple", "Apple", "apple.png", 5)
PyuTestCore.make_food("pyutest_core:bread", "Bread", "bread.png", 3)
