local function get_items_from_group(name)
  local list = {}
  for k, v in pairs(minetest.registered_items) do
    if minetest.get_item_group(k, name) ~= 0 then
      table.insert(list, k)
    end
  end
  return list
end

-- Remove built-in Unified Inventory categories
for k, v in pairs(unified_inventory.registered_categories) do
  unified_inventory.remove_category(k)
end

unified_inventory.register_category("pyutest_inventory:blocks", {
  symbol = "pyutest_core:stone_block",
  label = "Blocks",
  index = 3,
  items = get_items_from_group("block")
})

unified_inventory.register_category("pyutest_inventory:tools", {
  symbol = "pyutest_core:iron_pickaxe",
  label = "Tools",
  index = 4,
  items = get_items_from_group("tool")
})

unified_inventory.register_category("pyutest_inventory:furniture", {
  symbol = "pyutest_core:wooden_wood_chair",
  label = "Furniture",
  index = 5,
  items = get_items_from_group("furniture")
})

unified_inventory.register_category("pyutest_inventory:minerals", {
  symbol = "pyutest_core:diamond_ore",
  label = "Minerals",
  index = 6,
  items = get_items_from_group("mineral")
})

unified_inventory.register_category("pyutest_inventory:colored", {
  symbol = "pyutest_core:yellow_wool_block",
  label = "Colored Blocks",
  index = 7,
  items = get_items_from_group("colored")
})

unified_inventory.register_category("pyutest_inventory:flowers", {
  symbol = "pyutest_core:rose",
  label = "Flora",
  index = 8,
  items = get_items_from_group("flower")
})

unified_inventory.register_category("pyutest_inventory:fuel", {
  symbol = "pyutest_core:coal_lump",
  label = "Fuel",
  index = 9,
  items = get_items_from_group("fuel")
})


unified_inventory.register_category("pyutest_inventory:whole_blocks", {
  symbol = "pyutest_core:stone_block",
  label = "Whole Blocks",
  index = 10,
  items = get_items_from_group("whole_block")
})
