PyuTestCore.make_item = function (nsname, desc, groups, wield_image, extra_conf)
  local conf = {
    description = Translate(desc),
    wield_image = wield_image,
    inventory_image = wield_image,
    groups = groups
  }

  if extra_conf ~= nil then
    for k, v in pairs(extra_conf) do
      conf[k] = v
    end
  end

  minetest.register_craftitem(nsname, conf)
end

PyuTestCore.make_item("pyutest_core:stick", "Stick", {}, "stick.png")

PyuTestCore.make_item("pyutest_core:bone", "Bone", {}, "bone.png", {
  stack_max = 99
})

PyuTestCore.make_item("pyutest_core:gunpowder", "Gunpowder", {}, "powder.png", {
  color = "dimgray",
})

PyuTestCore.make_item("pyutest_core:ash", "Ash", {}, "powder.png", {
  color = "gray",
})

PyuTestCore.make_item("pyutest_core:sugar", "Sugar", {}, "powder.png")

PyuTestCore.make_item("pyutest_core:coin", "Coin", {}, "coin.png", {
  on_secondary_use = function (_, user)
    local pos = user:get_pos()
    minetest.sound_play({name = "coin", gain = 1}, {
      pos = pos
    })
    return nil
  end
})

PyuTestCore.make_item("pyutest_core:wheat", "Wheat", {}, "wheat.png")
PyuTestCore.make_item("pyutest_core:string", "String", {}, "string.png")
PyuTestCore.make_item("pyutest_core:egg", "Egg", {}, "egg.png", {
  color = "peachpuff"
})
PyuTestCore.make_item("pyutest_core:clay", "Clay Ball", {}, "clay.png")
PyuTestCore.make_item("pyutest_core:glass_bottle", "Glass Bottle", {}, "glass-bottle.png", {
  stack_max = 16
})
PyuTestCore.make_item("pyutest_core:brick", "Brick", {}, "brick.png")
PyuTestCore.make_item("pyutest_core:snowball", "Snowball", {}, "snowball.png")
PyuTestCore.make_item("pyutest_core:bone", "Bone", {}, "bone.png")
