local snowball_hit_player = function (self, player)
  player:punch(self.object, nil, {
    damage_groups = {fleshy = 9}
  }, nil)
end

mobs:register_arrow("pyutest_mobs:arrow_snowball", {
  visual = "sprite",
  visual_size = {x = 1, y = 1},
  textures = {"snowball.png"},
  hit_node = function (self, pos)
    PyuTestCore.create_explosion(pos, 1, false, 9, self.object, false)
  end,
  hit_player = snowball_hit_player,
  hit_mob = snowball_hit_player,
  velocity = 9,
  collisionbox = {
    -1.5, -1.5, -1.5, 1.5, 1.5, 1.5
  }
})


mobs:register_mob("pyutest_mobs:snowman", {
  type = "monster",
  hp_max = 450,
  hp_min = 450,
  walk_velocity = 1,
  run_velocity = 4,
  armor = 100,
  passive = false,
  walk_chance = 1,
  stand_chance = 2,
  damage = 9,
  attack_chance = 1,
  attack_type = "dogshoot",
  arrow = "pyutest_mobs:arrow_snowball",
  shoot_interval = 0.75,
  shoot_offset = 2,
  homing = true,
  pathfinding = 1,
  visual = "upright_sprite",
  visual_size = {x = 1, y = 2},
  collisionbox = PyuTestMobs.HUMAN_LIKE_CBOX,
  physical = true,
  blood_amount = PyuTestMobs.ENTITY_BLOOD_AMOUNT,
  view_range = 35,
  reach = 2,
  jump = 1,
  group_attack = false,
  makes_footstep_sound = true,
  dogshoot_switch = 2,
  dogshoot_count_max = 3,
  dogshoot_count2_max = 6,

  textures = {
    "snowman.png", "snowman_back.png"
  },

  drops = {
    {
      name = "pyutest_core:magic_shards",
      min = 2,
      max = 5,
      chance = 1
    },

    {
      name = "pyutest_core:snowball",
      min = 4,
      max = 9,
      chance = 1
    }
  }
})
PyuTestMobs.create_boss_egg("pyutest_mobs:snowman", "Snowman Spawn Egg",
  "egg.png^[multiply:skyblue", 0, nil,
  "pyutest_core:snow_block")
