PyuTestMobs_Path = minetest.get_modpath("pyutest_mobs")


mobs.fallback_node = "pyutest_core:dirt_block"

dofile(PyuTestMobs_Path.."/api.lua")

dofile(PyuTestMobs_Path.."/basic.lua")
dofile(PyuTestMobs_Path.."/snowman.lua")
dofile(PyuTestMobs_Path.."/wind_warrior.lua")
dofile(PyuTestMobs_Path.."/necromancer.lua")

local mapgen = minetest.get_mapgen_params().mgname or "???"
if mapgen ~= "flat" and mapgen ~= "singlenode" then
  mobs:spawn({
    name = "pyutest_mobs:monster",
    nodes = {"group:ground"},
    interval = 6,
    chance = 4,
    active_object_count = 3,
    min_light = 0,
    max_light = 8,
    y_max = PyuTestCore_WorldTop,
    y_min = PyuTestCore_SurfaceBottom
  })

  mobs:spawn({
    name = "pyutest_mobs:monster",
    nodes = {"group:ground"},
    interval = 2,
    chance = 2,
    active_object_count = 6,
    min_light = 0,
    max_light = 8,
    y_max = PyuTestCore_DeepOceanMin - 1,
    y_min = PyuTestCore_WorldBottom
  })

  mobs:spawn({
    name = "pyutest_mobs:human",
    nodes = {"group:ground"},
    interval = 3,
    chance = 4,
    active_object_count = 3,
    min_light = 9,
    max_light = 15,
    min_height = PyuTestCore_SurfaceBottom,
    day_toggle = true,
  })

  mobs:spawn({
    name = "pyutest_mobs:mimic",
    nodes = {"group:ground"},
    interval = 3,
    chance = 18,
    active_object_count = 2,
    min_light = 0,
    max_light = 15,
    day_toggle = true,
  })

  mobs:spawn({
    name = "pyutest_mobs:firefly",
    nodes = {"group:ground", "air"},
    interval = 3,
    chance = 3,
    active_object_count = 4,
    min_light = 0,
    max_light = 9,
    day_toggle = false,
  })
end
