PyuTestCore.make_building_blocks("pyutest_core:granite", "Granite", {"granite.png"}, nil, {
  ground = 1,
  stone = 1,
  block = PyuTestCore.BLOCK_BREAKABLE_MIDDLE
})

PyuTestCore.make_building_blocks("pyutest_core:andesite", "Andesite", {"andesite.png"}, nil, {
  ground = 1,
  stone = 1,
  block = PyuTestCore.BLOCK_BREAKABLE_MIDDLE
})

PyuTestCore.SPECIALSTONE_NOISE_PARAMS = {
  offset = 0,
  scale = 1,
  spread = {x = 250, y = 250, z = 250},
  seed = 1536,
  octaves = 3,
  persist = 0.4,
  lacunarity = 2,
  flags = "defaults"
}

minetest.register_ore({
  ore_type = "blob",
  ore = "pyutest_core:granite_block",
  wherein = "pyutest_core:stone_block",
  clust_scarcity = 9 * 9 * 9,
  clust_num_ores = 35,
  clust_size = 5,
  y_max = PyuTestCore_SurfaceBottom - 1,
  y_min = PyuTestCore_WorldBottom,
  noise_params = PyuTestCore.SPECIALSTONE_NOISE_PARAMS
})

minetest.register_ore({
  ore_type = "blob",
  ore = "pyutest_core:andesite_block",
  wherein = "pyutest_core:stone_block",
  clust_scarcity = 9 * 9 * 9,
  clust_num_ores = 35,
  clust_size = 5,
  y_max = PyuTestCore_SurfaceBottom - 1,
  y_min = PyuTestCore_WorldBottom,
  noise_params = PyuTestCore.SPECIALSTONE_NOISE_PARAMS
})

minetest.register_ore({
  ore_type = "blob",
  ore = "pyutest_core:clay_block",
  wherein = "pyutest_core:gravel_block",
  clust_scarcity = 7 * 7 * 7,
  clust_num_ores = 35,
  clust_size = 5,
  y_max = PyuTestCore_SurfaceBottom - 1,
  y_min = PyuTestCore_DeepOceanMin,
  noise_params = PyuTestCore.SPECIALSTONE_NOISE_PARAMS
})

PyuTestCore.ORE_STONES = {
  "pyutest_core:stone_block",
  "pyutest_core:granite_block",
  "pyutest_core:andesite_block",
}

PyuTestCore.make_ore = function (id, desc, ifix, idfix, btxt, itxt, color, y_max, scarcity, count, btype, oconf, bconf)
  local oid = id.."_ore"
  local iid = id.."_"..ifix
  local block_type = btype ~= nil and btype or PyuTestCore.BLOCK_BREAKABLE_LONG

  minetest.register_node(oid, PyuTestCore.util.tableconcat({
    description = Translate(desc .. " Ore"),
    groups = {
      block = block_type,
      mineral = 1
    },
    tiles = {btxt},
    drop = iid .. " " .. tostring(count or 1),
    sounds = PyuTestCore.make_node_sounds(),
    light_source = 3.9, -- Make ores emit little light
  }, oconf or {}))

  minetest.register_craftitem(iid, {
    description = Translate(desc .. " " .. idfix),
    inventory_image = itxt,
    wield_image = itxt,
    color = color,
    groups = {
      mineral = 1
    }
  })

  minetest.register_ore({
    ore_type = "scatter",
    ore = oid,
    wherein = PyuTestCore.ORE_STONES,
    clust_scarcity = scarcity * scarcity * scarcity,
    clust_num_ores = 4,
    clust_size = 3,
    y_max = y_max,
    y_min = PyuTestCore_WorldBottom,
  })

  minetest.register_ore({
    ore_type = "scatter",
    ore = oid,
    wherein = PyuTestCore.ORE_STONES,
    clust_scarcity = scarcity * scarcity * scarcity * 2.2,
    clust_num_ores = 9,
    clust_size = 3,
    y_max = y_max,
    y_min = PyuTestCore_WorldBottom,
  })

  minetest.register_ore({
    ore_type = "scatter",
    ore = oid,
    wherein = PyuTestCore.ORE_STONES,
    clust_scarcity = (scarcity * scarcity * scarcity) * 3,
    clust_num_ores = 18,
    clust_size = 6,
    y_max = y_max,
    y_min = PyuTestCore_WorldBottom,
  })

  PyuTestCore.make_building_blocks(id, desc, {"metal.png"}, color, {block = block_type}, bconf or {})

  local bid = id.."_block"
  minetest.register_craft({
    output = bid,
    recipe = {
      {iid, iid},
      {iid, iid}
    }
  })

  minetest.register_craft({
    output = iid .. " 4",
    recipe = {
      bid
    },
    type = "shapeless"
  })
end

-- Useful Ores
PyuTestCore.make_ore("pyutest_core:coal", "Coal", "lump", "Lump", "ore-coal.png", "lump.png", {r = 32, g = 32, b = 32}, 48, 8, 2, PyuTestCore.BLOCK_BREAKABLE_MIDDLE)
PyuTestCore.make_ore("pyutest_core:copper", "Copper", "ingot", "Ingot", "ore-copper.png", "ingot.png", "darkgoldenrod", 18, 11, 2, PyuTestCore.BLOCK_BREAKABLE_MIDDLE)
PyuTestCore.make_ore("pyutest_core:tin", "Tin", "ingot", "Ingot", "ore-tin.png", "ingot.png", "#8e8591", 18, 11, 1, PyuTestCore.BLOCK_BREAKABLE_MIDDLE)
PyuTestCore.make_ore("pyutest_core:iron", "Iron", "ingot", "Ingot", "ore-iron.png", "ingot.png", nil, 18, 11, 1)
PyuTestCore.make_ore("pyutest_core:gold", "Gold", "ingot", "Ingot", "ore-gold.png", "ingot.png", "gold", -75, 15.5, 1)
PyuTestCore.make_ore("pyutest_core:diamond", "Diamond", "shard", "Shard", "ore-diamond.png", "shard.png", "cyan", -90, 16.7, 1)
PyuTestCore.make_ore("pyutest_core:emerald", "Emerald", "shard", "Shard", "ore-emerald.png", "shard.png", "seagreen", -120, 18.3, 1)

-- Ores without any special uses
PyuTestCore.make_ore("pyutest_core:zinc", "Zinc", "ingot", "Ingot", "ore-zinc.png", "ingot.png", "#bed3d4", 18, 13, 1)
PyuTestCore.make_ore("pyutest_core:lapis_lazuli", "Lapis Lazuli", "lump", "Lump", "ore-lapis.png", "lump.png", "#3848AC", -25, 13.4, 1)
PyuTestCore.make_ore("pyutest_core:amethyst_quartz", "Amethyst Quartz", "shard", "Shard", "ore-amethyst.png", "shard.png", "#9f7ba9", -50, 14.1, 1)
PyuTestCore.make_ore("pyutest_core:pink_quartz", "Pink Quartz", "shard", "Shard", "ore-pink-quartz.png", "shard.png", "#dbafdc", -50, 14.1, 1)
PyuTestCore.make_ore("pyutest_core:ruby", "Ruby", "shard", "Shard", "ore-ruby.png", "shard.png", "#992727", -75, 15.5, 1)
