--[[
  Format:

  user = {
    name = {
      pos = {x = 128, y = 50, z = 256},
      idx = 439
    }
  }

]]
local waypoints = {}

minetest.register_chatcommand("waypoint", {
  params = "<name>",
  description = [[Creates a waypoint at your position called <NAME>
If the waypoint is already set, move the waypoint.]],
  func = function (name, param)
    if waypoints[name] == nil then
      waypoints[name] = {}
    end

    local player = minetest.get_player_by_name(name)
    if player == nil then return end

    if waypoints[name][param] ~= nil then
      player:hud_remove(waypoints[name][param].idx)
    end

    local pos = player:get_pos()

    waypoints[name][param] = {}
    waypoints[name][param].pos = pos

    local idx = player:hud_add({
      hud_elem_type = "waypoint",
      name = param,
      text = "m",
      world_pos = pos,
      number = 0xFFFFFFFF,
    })
    waypoints[name][param].idx = idx
  end
})

minetest.register_chatcommand("teleportwaypoint", {
  params = "<name>",
  description = "Teleport to waypoint NAME",
  func = function (name, param)
    if waypoints[name] == nil then
      waypoints[name] = {}
    end
    if waypoints[name][param] == nil then return end

    local player = minetest.get_player_by_name(name)
    if player == nil then return end

    player:set_pos(waypoints[name][param].pos)
  end
})

minetest.register_chatcommand("biome", {
  description = "Return the current biome name",
  func = function (name)
    local player = minetest.get_player_by_name(name)
    if player == nil then return end

    local pos = player:get_pos()

    local name = minetest.get_biome_name(minetest.get_biome_data(pos).biome)
    return true, string.format("Current biome name: %s", name)
  end
})
