PyuTestCore.make_leaves = function (id, desc, tiles)
  local _id = id ~= nil and id.."_leaves" or "pyutest_core:leaves" -- backwards compatability with original leaves
  local _desc = desc ~= nil and desc .. " Leaves" or "Leaves"

  PyuTestCore.make_building_blocks(_id, _desc, tiles, nil, {
    acid_vulnerable = 1,
    flammable = 1,
  }, {
    is_ground_content = false
  })

  local leaves_id = _id.."_block"
  minetest.override_item(leaves_id, {
    drop = {
      max_items = 1,
      items = {
        {
          rarity = 3.5,
          items = {"pyutest_core:apple 1"}
        },

        {
          items = {leaves_id}
        }
      }
    }
  })
end

PyuTestCore.make_leaves(nil, nil, {"pyutest-leaves.png"})
PyuTestCore.make_leaves("pyutest_core:snowy", "Snowy", {"pyutest-snowy-leaves.png"})
PyuTestCore.make_leaves("pyutest_core:cherry", "Cherry", {"pyutest-cherry-leaves.png"})
PyuTestCore.make_leaves("pyutest_core:dark", "Dark", {"pyutest-dark-leaves.png"})
PyuTestCore.make_leaves("pyutest_core:aspen", "Aspen", {"pyutest-aspen-leaves.png"})
PyuTestCore.make_leaves("pyutest_core:red_aspen", "Red Aspen", {"pyutest-red-aspen-leaves.png"})
