minetest.register_alias("mapgen_stone", "pyutest_core:stone_block")
minetest.register_alias("mapgen_water_source", "pyutest_core:water_source")
minetest.register_alias("mapgen_river_water_source", "pyutest_core:water_source")
minetest.register_alias("mapgen_lava_source", "pyutest_core:lava_source")
minetest.register_alias("mapgen_singlenode", "air")

-- Biomes

PyuTestCore_BiomeTops = {
  grassland = 40,
  forest = 45,
  desert = 70,
  frozen_plains = 50,
  mountains = 300,
  mushroom_fields = 40,
  ice_spikes = 250,
  swamp = 10
}

PyuTestCore.BIOME_TYPES = {
  -- Normal biomes (Forests for example)
  NORMAL = 1,

  -- Chilly biomes, but not snowy (Taigas for example)
  CHILLY = 2,

  -- Snowy biomes (Frozen Plains for example)
  COLD = 3,

  -- Warm biomes (Savannas for example)
  WARM = 4,

  -- Hot biomes (Deserts for example)
  DESERT = 5,

  -- Wasteland biomes (Wastelands and Volcano for example)
  WASTELAND = 6,

  -- Wetland biomes (Swamps for example)
  WETLAND = 7,

  -- Ocean biomes (What example do you want?)
  OCEAN = 8,

  -- Cave biomes (What example do you want?)
  CAVE = 9
}

PyuTestCore.get_biomes_from_type = function(type)
  local biomes = {}

  for k, v in pairs(minetest.registered_biomes) do
    if v._pyutest_biome_type == type then
      biomes[k] = v
    end
  end

  return biomes
end

PyuTestCore.get_flowering_biomes = function ()
  local biomes = {}

  for k, v in pairs(minetest.registered_biomes) do
    if v._pyutest_biome_flowering == true and v._pyutest_biome_flowering_extra == false then
      table.insert(biomes, k)
    end
  end

  return biomes
end

PyuTestCore.get_extra_flowering_biomes = function ()
  local biomes = {}

  for k, v in pairs(minetest.registered_biomes) do
    if v._pyutest_biome_flowering == true and v._pyutest_biome_flowering_extra == true then
      table.insert(biomes, k)
    end
  end

  return biomes
end

-- wrapper around minetest.register_biome but with defaults and caves
PyuTestCore.register_biome = function(name, type, opts)
  local nopts = PyuTestCore.util.tablecopy(opts) or {}
  nopts["name"] = name
  nopts["depth_top"] = nopts["depth_top"] or 1
  nopts["depth_filler"] = nopts["depth_filler"] or 3
  nopts["depth_riverbed"] = nopts["depth_riverbed"] or 2
  nopts["depth_water_top"] = nopts["depth_water_top"] or nil -- cant think of a sane default..

  nopts["node_water"] = nopts["node_water"] or "pyutest_core:water_source"
  nopts["node_river_water"] = nopts["node_river_water"] or "pyutest_core:water_source"
  nopts["node_riverbed"] = nopts["node_riverbed"] or "pyutest_core:gravel_block"

  minetest.register_biome(PyuTestCore.util.tableconcat(nopts, {
    _pyutest_biome_type = type,
  }))

  minetest.register_biome(PyuTestCore.util.tableconcat({
    name = name.."_ocean",
    node_top = nopts["node_riverbed"],
    depth_top = 2,
    node_filler = nopts["node_riverbed"],
    depth_filler = 3,
    depth_riverbed = 2,

    node_water = nopts["node_water"],
    node_river_water = nopts["node_river_water"],

    heat_point = nopts["heat_point"],
    humidity_point = nopts["humidity_point"],

    y_max = 0,
    y_min = PyuTestCore_OceanMin
  }, {
    _pyutest_biome_type = PyuTestCore.BIOME_TYPES.OCEAN,
    _pyutest_ocean_type = type
  }))

  minetest.register_biome(PyuTestCore.util.tableconcat({
    name = name.."_deep_ocean",

    node_top = nopts["node_riverbed"],
    depth_top = 2,
    node_filler = nopts["node_riverbed"],
    depth_filler = 3,
    depth_riverbed = 2,

    node_water = nopts["node_water"],
    node_river_water = nopts["node_river_water"],

    heat_point = nopts["heat_point"],
    humidity_point = nopts["humidity_point"],

    y_max = PyuTestCore_DeepOceanMax,
    y_min = PyuTestCore_DeepOceanMin,

    vertical_blend = 5
  }, {
    _pyutest_biome_type = PyuTestCore.BIOME_TYPES.OCEAN,
    _pyutest_ocean_type = type
  }))

  minetest.register_biome(PyuTestCore.util.tableconcat({
    name = name.."_cave",
    heat_point = nopts["heat_point"],
    humidity_point = nopts["humidity_point"],
    y_max = PyuTestCore_DeepOceanMin - 1,
    y_min = PyuTestCore_WorldBottom
  }, {
    _pyutest_biome_type = PyuTestCore.BIOME_TYPES.CAVE,
    _pyutest_cave_type = type
  }))
end

PyuTestCore.register_biome("grassland", PyuTestCore.BIOME_TYPES.NORMAL, {
  node_top = "pyutest_core:grass_block",
  node_filler = "pyutest_core:dirt_block",

  y_max = PyuTestCore_BiomeTops.grassland,
  y_min = PyuTestCore_SurfaceBottom,

  heat_point = 53,
  humidity_point = 50,

  _pyutest_biome_flowering = true
})

PyuTestCore.register_biome("forest", PyuTestCore.BIOME_TYPES.NORMAL, {
  node_top = "pyutest_core:dark_grass_block",
  node_filler = "pyutest_core:dirt_block",

  y_max = PyuTestCore_BiomeTops.forest,
  y_min = PyuTestCore_SurfaceBottom,

  heat_point = 50,
  humidity_point = 65,
  _pyutest_biome_flowering = true
})

PyuTestCore.register_biome("stony_mountains", PyuTestCore.BIOME_TYPES.CHILLY, {
  node_top = "pyutest_core:stone_block",
  node_filler = "pyutest_core:stone_block",

  y_max = PyuTestCore_BiomeTops.mountains,
  y_min = PyuTestCore_BiomeTops.grassland,

  heat_point = 45,
  humidity_point = 34
})

PyuTestCore.register_biome("desert", PyuTestCore.BIOME_TYPES.DESERT, {
  node_top = "pyutest_core:sand_block",
  node_filler = "pyutest_core:sandstone_block",
  node_riverbed = "pyutest_core:sand_block",

  y_max = PyuTestCore_BiomeTops.desert,
  y_min = PyuTestCore_SurfaceBottom,

  heat_point = 84,
  humidity_point = 4
})

PyuTestCore.register_biome("desert_mountains", PyuTestCore.BIOME_TYPES.DESERT, {
  node_top = "pyutest_core:sand_block",
  node_filler = "pyutest_core:sandstone_block",

  y_max = PyuTestCore_BiomeTops.mountains,
  y_min = PyuTestCore_BiomeTops.desert,

  heat_point = 83,
  humidity_point = 6
})

PyuTestCore.register_biome("snowy_mountains", PyuTestCore.BIOME_TYPES.COLD, {
  node_top = "pyutest_core:snow_block",
  node_filler = "pyutest_core:snow_block",

  y_max = PyuTestCore_BiomeTops.mountains,
  y_min = PyuTestCore_BiomeTops.frozen_plains,

  heat_point = 6,
  humidity_point = 45
})

PyuTestCore.register_biome("frozen_plains", PyuTestCore.BIOME_TYPES.COLD, {
  node_dust = "pyutest_core:snow_carpet",

  node_top = "pyutest_core:snow_block",
  node_filler = "pyutest_core:snow_block",

  y_max = PyuTestCore_BiomeTops.frozen_plains,
  y_min = PyuTestCore_SurfaceBottom,

  node_water_top = "pyutest_core:ice_block",
  depth_water_top = 5,

  heat_point = 9,
  humidity_point = 40
})

PyuTestCore.register_biome("mushroom_fields", PyuTestCore.BIOME_TYPES.NORMAL, {
  node_top = "pyutest_core:mycelium_block",
  node_filler = "pyutest_core:dirt_block",

  y_max = PyuTestCore_BiomeTops.mushroom_fields,
  y_min = PyuTestCore_SurfaceBottom,

  heat_point = 42,
  humidity_point = 94
})

PyuTestCore.register_biome("ice_spikes", PyuTestCore.BIOME_TYPES.COLD, {
  node_top = "pyutest_core:ice_block",
  node_filler = "pyutest_core:ice_block",

  y_max = PyuTestCore_BiomeTops.ice_spikes,
  y_min = PyuTestCore_SurfaceBottom,

  node_water_top = "pyutest_core:ice_block",
  depth_water_top = 5,

  heat_point = 9,
  humidity_point = 47
})

PyuTestCore.register_biome("meadow", PyuTestCore.BIOME_TYPES.NORMAL, {
  node_top = "pyutest_core:dark_grass_block",
  node_filler = "pyutest_core:dirt_block",
  depth_filler = 4,

  y_max = PyuTestCore_BiomeTops.mountains,
  y_min = PyuTestCore_SurfaceBottom,

  heat_point = 52,
  humidity_point = 83,

  _pyutest_biome_flowering = true,
  _pyutest_biome_flowering_extra = true
})

PyuTestCore.register_biome("old_growth_forest", PyuTestCore.BIOME_TYPES.NORMAL, {
  node_top = "pyutest_core:dark_grass_block",
  node_filler = "pyutest_core:dirt_block",

  y_max = PyuTestCore_BiomeTops.forest,
  y_min = PyuTestCore_SurfaceBottom,

  heat_point = 45,
  humidity_point = 92,

  _pyutest_biome_flowering = true
})

PyuTestCore.register_biome("snowy_forest", PyuTestCore.BIOME_TYPES.COLD, {
  node_top = "pyutest_core:snow_block",
  node_filler = "pyutest_core:dirt_block",

  y_max = PyuTestCore_BiomeTops.forest,
  y_min = PyuTestCore_SurfaceBottom,

  node_water_top = "pyutest_core:ice_block",
  depth_water_top = 5,

  heat_point = 8,
  humidity_point = 43
})

PyuTestCore.register_biome("savanna", PyuTestCore.BIOME_TYPES.WARM, {
  node_top = "pyutest_core:savanna_grass_block",
  node_filler = "pyutest_core:dirt_block",

  y_max = PyuTestCore_BiomeTops.grassland,
  y_min = PyuTestCore_SurfaceBottom,

  heat_point = 72,
  humidity_point = 9
})

PyuTestCore.register_biome("taiga", PyuTestCore.BIOME_TYPES.CHILLY, {
  node_top = "pyutest_core:dark_grass_block",
  node_filler = "pyutest_core:dirt_block",

  y_max = PyuTestCore_BiomeTops.forest,
  y_min = PyuTestCore_SurfaceBottom,

  heat_point = 28,
  humidity_point = 53,

  _pyutest_biome_flowering = true
})

PyuTestCore.register_biome("birch_forest", PyuTestCore.BIOME_TYPES.NORMAL, {
  node_top = "pyutest_core:grass_block",
  node_filler = "pyutest_core:dirt_block",

  y_max = PyuTestCore_BiomeTops.forest,
  y_min = PyuTestCore_SurfaceBottom,

  heat_point = 48,
  humidity_point = 85,

  _pyutest_biome_flowering = true
})

PyuTestCore.register_biome("cherry_grove", PyuTestCore.BIOME_TYPES.NORMAL, {
  node_top = "pyutest_core:grass_block",
  node_filler = "pyutest_core:dirt_block",

  y_max = PyuTestCore_BiomeTops.forest,
  y_min = PyuTestCore_SurfaceBottom,

  heat_point = 52,
  humidity_point = 78,

  _pyutest_biome_flowering = true,
  _pyutest_biome_flowering_extra = true
})

PyuTestCore.register_biome("swamp", PyuTestCore.BIOME_TYPES.WETLAND, {
  node_top = "pyutest_core:swampy_grass_block",
  node_filler = "pyutest_core:dirt_block",

  y_max = PyuTestCore_BiomeTops.swamp,
  y_min = PyuTestCore_SurfaceBottom,

  heat_point = 30,
  humidity_point = 88,
})

PyuTestCore.register_biome("old_growth_birch_forest", PyuTestCore.BIOME_TYPES.NORMAL, {
  node_top = "pyutest_core:grass_block",
  node_filler = "pyutest_core:dirt_block",

  y_max = PyuTestCore_BiomeTops.forest,
  y_min = PyuTestCore_SurfaceBottom,

  heat_point = 47,
  humidity_point = 80,

  _pyutest_biome_flowering = true,
  _pyutest_biome_flowering_extra = true
})

PyuTestCore.register_biome("aspen_forest", PyuTestCore.BIOME_TYPES.CHILLY, {
  node_top = "pyutest_core:aspen_grass_block",
  node_filler = "pyutest_core:dirt_block",

  y_max = PyuTestCore_BiomeTops.forest,
  y_min = PyuTestCore_SurfaceBottom,

  heat_point = 25,
  humidity_point = 52,

  _pyutest_biome_flowering = true
})

PyuTestCore.register_biome("redwood_forest", PyuTestCore.BIOME_TYPES.CHILLY, {
  node_top = "pyutest_core:podzol_block",
  node_filler = "pyutest_core:podzol_block",

  y_max = PyuTestCore_BiomeTops.forest,
  y_min = PyuTestCore_SurfaceBottom,

  heat_point = 28,
  humidity_point = 54,

  _pyutest_biome_flowering = true
})

PyuTestCore.register_biome("jungle", PyuTestCore.BIOME_TYPES.WARM, {
  node_top = "pyutest_core:jungle_grass_block",
  node_filler = "pyutest_core:dirt_block",

  y_max = PyuTestCore_BiomeTops.forest,
  y_min = PyuTestCore_SurfaceBottom,

  heat_point = 48,
  humidity_point = 97,

  _pyutest_biome_flowering = true,
  _pyutest_biome_flowering_extra = true
})

PyuTestCore.register_biome("large_mushroom_forest", PyuTestCore.BIOME_TYPES.NORMAL, {
  node_top = "pyutest_core:mycelium_block",
  node_filler = "pyutest_core:dirt_block",

  y_max = PyuTestCore_BiomeTops.mushroom_fields,
  y_min = PyuTestCore_SurfaceBottom,

  heat_point = 43,
  humidity_point = 98
})
