-- player setup
minetest.register_on_joinplayer(function (player)
  if player == nil then return end
  local name = player:get_player_name()
  player:set_properties({
    hp_max = 30
  })

  player:get_inventory():set_width("main", 8)
  player:get_inventory():set_size("main", 8 * 4)
  player:hud_set_hotbar_itemcount(8)

  -- creative mode privs
  if minetest.is_creative_enabled(name) then
    minetest.set_player_privs(name, PyuTestCore.util.tableconcat({
      fly = true,
      fast = true,
      noclip = true,
      builder = true,
      settime = true,
      creative = true,
      peaceful_player = true, -- from mobs_redo
      teleport = true,
    }, minetest.get_player_privs(name)))
  end
end)

-- player physics
local function set_player_speed(player, speed)
  player:set_physics_override({
    speed = speed,
  })
end

minetest.register_globalstep(function(dtime)
   local players = minetest.get_connected_players()
   for p=1, #players do
      local ctrl = players[p]:get_player_control()
      if ctrl.aux1 then
        set_player_speed(players[p], 1.60)
      else
        set_player_speed(players[p], 1)
      end
   end
end)

-- player hand
minetest.register_item(":", {
  type = "none",
  wield_image = "pyutest-hand.png"
})

if minetest.is_creative_enabled("")  then
  local break_speed = 0.2

  minetest.override_item("", {
    range = 9,
    tool_capabilities = {
      groupcaps = {
        block = {
          times = {
            [PyuTestCore.BLOCK_BREAKABLE_INSTANT] = break_speed,
            [PyuTestCore.BLOCK_BREAKABLE_NORMAL] = break_speed,
            [PyuTestCore.BLOCK_BREAKABLE_CHOPPY] = break_speed,
            [PyuTestCore.BLOCK_BREAKABLE_MIDDLE] = break_speed,
            [PyuTestCore.BLOCK_BREAKABLE_LONG] = break_speed,
            [PyuTestCore.BLOCK_BREAKABLE_VERYLONG] = break_speed,
            [PyuTestCore.BLOCK_BREAKABLE_FOREVER] = break_speed
          },
          uses = 0
        }
      },
      punch_attack_uses = 0,
      damage_groups = {fleshy = 10000}
    }
  })
else
  minetest.override_item("", {
    range = 6,
    tool_capabilities = {
      groupcaps = {
        block = {
          times = {
            [PyuTestCore.BLOCK_BREAKABLE_INSTANT] = 0.35,
            [PyuTestCore.BLOCK_BREAKABLE_NORMAL] = 0.85,
            [PyuTestCore.BLOCK_BREAKABLE_CHOPPY] = 3,
            [PyuTestCore.BLOCK_BREAKABLE_MIDDLE] = 5.5,
            [PyuTestCore.BLOCK_BREAKABLE_LONG] = 9,
            [PyuTestCore.BLOCK_BREAKABLE_VERYLONG] = 12,
            [PyuTestCore.BLOCK_BREAKABLE_FOREVER] = 18
          },
          uses = 0
        }
      },
      punch_attack_uses = 0,
      damage_groups = {fleshy = 1}
    }
  })
end

-- unlimited blocks in creative mode
minetest.register_on_placenode(function(_, _, placer)
  if placer and placer:is_player() then
    return minetest.is_creative_enabled(placer:get_player_name())
  end
end)
