PyuTestCore.make_wood = function (id, desc, ltiles, btiles)
  PyuTestCore.make_building_blocks(id.."_log", desc .. " Log", ltiles, nil, {
    block = PyuTestCore.BLOCK_BREAKABLE_CHOPPY,
    acid_vulnerable = 1,
    flammable = 1,
    fuel = 1
  }, {
    is_ground_content = false
  })

  PyuTestCore.make_building_blocks(id.."_wood", desc .. " Wood", btiles, nil, {
    block = PyuTestCore.BLOCK_BREAKABLE_CHOPPY,
    acid_vulnerable = 1,
    flammable = 1,
    fuel = 1
  }, {
    is_ground_content = false
  })

  local log_id = id.."_log_block"
  local wood_id = id.."_wood_block"

  minetest.override_item(log_id, {
    groups = PyuTestCore.util.tableconcat(minetest.registered_nodes[log_id].groups, {
      wooden_log = 1
    }),
    paramtype2 = "facedir",
    on_place = minetest.rotate_node
  })

  minetest.override_item(wood_id, {
    groups = PyuTestCore.util.tableconcat(minetest.registered_nodes[wood_id].groups, {
      wooden_planks = 1
    })
  })

  minetest.register_craft({
    output = id.."_wood_block 4",
    recipe = {id.."_log_block"},
    type = "shapeless"
  })
end

PyuTestCore.make_wood("pyutest_core:wooden", "Oak", {
  "pyutest-log-top-bottom.png",
  "pyutest-log-top-bottom.png",
  "pyutest-log.png"
}, {
  "pyutest-wood.png"
})

PyuTestCore.make_wood("pyutest_core:savanna", "Savanna", {
  "pyutest-savanna-log-top-bottom.png",
  "pyutest-savanna-log-top-bottom.png",
  "pyutest-savanna-log.png"
}, {
  "pyutest-savanna-wood.png"
})

PyuTestCore.make_wood("pyutest_core:birch", "Birch", {
  "pyutest-birch-log-top-bottom.png",
  "pyutest-birch-log-top-bottom.png",
  "pyutest-birch-log.png"
}, {
  "pyutest-birch-wood.png"
})

PyuTestCore.make_wood("pyutest_core:cherry", "Cherry", {
  "pyutest-cherry-log-top-bottom.png",
  "pyutest-cherry-log-top-bottom.png",
  "pyutest-cherry-log.png"
}, {
  "pyutest-cherry-wood.png"
})

PyuTestCore.make_wood("pyutest_core:redwood", "Redwood", {
  "pyutest-redwood-log-top-bottom.png",
  "pyutest-redwood-log-top-bottom.png",
  "pyutest-redwood-log.png"
}, {
  "pyutest-redwood.png"
})

PyuTestCore.make_wood("pyutest_core:jungle", "Jungle", {
  "pyutest-jungle-log-top-bottom.png",
  "pyutest-jungle-log-top-bottom.png",
  "pyutest-jungle-log.png"
}, {
  "pyutest-jungle-wood.png"
})
