minetest.register_privilege("builder", {
		description = "Builder/World Edit Privilege",
		give_to_singeplayer = true
})

minetest.register_chatcommand("replacenear", {
		params = "<range> <from> <to>",
		description = [[Replace blocks around RANGE from FROM to TO.
FROM can be comma seperated, or it can be `any` which replaces any node.
Or it can be `anyblock` which replaces any node other than air and ignore.
]],
privs = {
	builder = true
},
func = function (name, param)
	local parts = param:split(" ")
	if #parts == 3 then
		local player = minetest.get_player_by_name(name)
		local pos = player:get_pos()
		local range = tonumber(parts[1]) or 5
		local from = parts[2]:split(",")
		local to = parts[3]
		local replaced = 0

		local function replace(p)
			for _, v in pairs(from) do
				local name = minetest.get_node(p).name
				local anyblock_match = (v == "anyblock" or v == "anynode" and name ~= "air" and name ~= "ignore")

				if name == v or v == "any" or anyblock_match then
					minetest.set_node(p, {name = to})
					replaced = replaced + 1
				end
			end
		end

		PyuTestCore.dorange(pos, range, function(p)
        replace(p)
		end)

		return true, string.format("Replaced %d blocks", replaced)
	end
	return false, "Requires 3 arguments"
end
})

minetest.register_chatcommand("place", {
		params = "<schematic>",
		description = "Place SCHEMATIC at player position",
		privs = {
			builder = true
		},
		func = function(name, param)
			local player = minetest.get_player_by_name(name)
			minetest.place_schematic(player:get_pos(),
				PyuTestCore.get_schem_path(param),
				"random",
				nil,
				false,
				"place_center_x, place_center_z"
			)
		end
})
