minetest.register_abm({
		label = "Sponge Loop",
		nodenames = {"pyutest_core:sponge"},
		neighbors = {"group:liquid"},
		interval = 0,
		chance = 1,
		action = function (pos)
			local range = 4

			local function replace(npos)
				local node = minetest.get_node(npos)
				if node.name == "air" then return end
				local def = minetest.registered_nodes[node.name]

				if def.groups["liquid"] == 1 then
					minetest.remove_node(npos)
				end
			end

			PyuTestCore.dorange(pos, range, function(p)
					replace(p)
			end)
		end
})

minetest.register_abm({
		label = "Contagious Acid Spread",
		nodenames = {"group:acid_vulnerable"},
		neighbors = {"pyutest_core:contagious_acid"},
		interval = 3.4,
		chance = 3.7,
		catchup = true,
		action = function (pos)
			minetest.set_node(pos, {
					name = "pyutest_core:contagious_acid"
			})
		end
})

minetest.register_abm({
		label = "Fire Spread",
		nodenames = {"group:flammable"},
		neighbors = {"pyutest_core:fire"},
		interval = 1,
		chance = 4,
		action = function (pos)
			minetest.set_node(pos, {
					name = "pyutest_core:fire"
			})
		end
})
