PyuTestCore.registered_flowers = {}
PyuTestCore.make_flower = function (name, desc, texture, dye, add_to_registry, drawtype, econf)
  PyuTestCore.make_node(name, desc, {
      block = PyuTestCore.BLOCK_BREAKABLE_INSTANT,
      flammable = 1,
      flower = 1,
      attached_node = 3,
      dig_immediate = 1
  }, {texture}, PyuTestCore.util.tableconcat({
        drawtype = drawtype or "plantlike",
        walkable = false,
        waving = 1,
        buildable_to = true,
        paramtype = "light",
        sunlight_propagates = true,
        inventory_image = texture
  }, econf or {}))

  if dye ~= nil then
    minetest.register_craft({
        output = dye .. " 2",
        recipe = {name},
        type = "shapeless"
    })
  end

  -- This is for plants like deadbushes which I do not want spawning in for say, Forests.
  if add_to_registry then
    table.insert(PyuTestCore.registered_flowers, name)
  end
end

-- Plants from before the floral update
PyuTestCore.make_flower("pyutest_core:rose", "Rose", "pyutest-flower.png", "pyutest_core:red_dye", true)
PyuTestCore.make_flower("pyutest_core:dandelion", "Dandelion", "pyutest-flower2.png", "pyutest_core:yellow_dye", true)
PyuTestCore.make_flower("pyutest_core:blue_daisy", "Blue Daisy", "pyutest-flower3.png", "pyutest_core:blue_dye", true)
PyuTestCore.make_flower("pyutest_core:lavender", "Lavender", "pyutest-flower4.png", "pyutest_core:purple_dye", true)

minetest.register_alias("pyutest_core:flower", "pyutest_core:rose")
minetest.register_alias("pyutest_core:flower2", "pyutest_core:dandelion")
minetest.register_alias("pyutest_core:flower3", "pyutest_core:blue_daisy")
minetest.register_alias("pyutest_core:flower4", "pyutest_core:lavender")

PyuTestCore.make_flower("pyutest_core:deadbush", "Deadbush", "pyutest-deadbush.png", "pyutest_core:brown_dye")
PyuTestCore.make_flower("pyutest_core:grass_plant", "Grass", "pyutest-grass-plant.png", "pyutest_core:green_dye")
PyuTestCore.make_flower("pyutest_core:sugarcane", "Sugarcane", "pyutest-sugarcane.png", "pyutest_core:green_dye", false, nil)

PyuTestCore.make_node("pyutest_core:lilypad", "Lily Pad", {
    block = PyuTestCore.BLOCK_BREAKABLE_INSTANT
}, {"pyutest-lilypad.png"}, {
    drawtype = "nodebox",
    paramtype = "light",
    paramtype2 = "facedir",
    buildable_to = true,
    sunlight_propagates = true,
    node_box = {
      type = "fixed",
      fixed = {-0.5, -31/64, -0.5, 0.5, -15/32, 0.5}
    },
})

-- Plants after the floral update
PyuTestCore.make_flower("pyutest_core:maybell", "Maybell", "pyutest-maybell.png", "pyutest_core:white_dye", true)
PyuTestCore.make_flower("pyutest_core:orange_tulip", "Orange Tulip", "pyutest-orange-tulip.png", "pyutest_core:orange_dye", true)
PyuTestCore.make_flower("pyutest_core:black_rose", "Black Rose", "pyutest-black-rose.png", "pyutest_core:black_dye", false)

PyuTestCore.make_node("pyutest_core:vines", "Vines", {
    block = PyuTestCore.BLOCK_BREAKABLE_INSTANT,
    attached_node = 1,
    flammable = 1
}, {"pyutest-vines.png"}, {
    drawtype = "signlike",
    paramtype = "light",
    walkable = false,
    climbable = true,
    buildable_to = true,
    sunlight_propagates = true,
    paramtype2 = "wallmounted",
    selection_box = {
      type = "wallmounted"
    },
    inventory_image = "pyutest-vines.png"
})

PyuTestCore.make_flower("pyutest_core:kelp", "Kelp", "pyutest-kelp.png", "pyutest_core:green_dye", false, "plantlike_rooted", {
    paramtype2 = "leveled",
    place_param2 = 128,
    wield_image = "pyutest-kelp.png",
    special_tiles = {
      {
        image = "pyutest-kelp.png",
        tileable_vertical = true
      },
    },
    tiles = {
      "pyutest-gravel.png"
    },

    walkable = true
})


PyuTestCore.make_flower("pyutest_core:small_mushroom",
  "Small Mushroom",
  "pyutest-mushroom-small.png",
  "pyutest_core:red_dye",
  false, nil, {
    groups = {
      block = PyuTestCore.BLOCK_BREAKABLE_INSTANT,
      flammable = 1,
      flower = 1,
      dig_immediate = 1,
      attached_node = 1
    },

    paramtype2 = "wallmounted"
})
