local necroball_hit_player = function (self, player)
  player:punch(self.object, nil, {
			damage_groups = {fleshy = 3}
  }, nil)
end

mobs:register_arrow("pyutest_mobs:arrow_necroball", {
		visual = "sprite",
		visual_size = {x = 1, y = 1},
		textures = {"pyutest-necroball.png"},
		hit_player = necroball_hit_player,
		hit_mob = necroball_hit_player,

		hit_node = function(self, pos)
			math.randomseed(os.time())
			local num_minions = math.random(2, 3)
			local minions = {
				"pyutest_mobs:monster",
				"pyutest_mobs:mimic"
			}
			local m = minions[math.random(#minions)]

			for i = 1, num_minions do
				mobs:add_mob(vector.add(pos, vector.new(0, 3, 0)), {
						name = m,
						child = false,
						nametag = "Necromancer Minion",
						ignore_count = true
				})
			end

			self.object:remove()
		end,
		velocity = 18,
		collisionbox = {
				-1.5, -1.5, -1.5, 1.5, 1.5, 1.5
		}
})

mobs:register_mob("pyutest_mobs:necromancer", {
    type = "monster",
    hp_max = 325,
    hp_min = 325,
    walk_velocity = 2,
    run_velocity = 4,
    armor = 100,
    passive = false,
    visual = "upright_sprite",
    visual_size = {x = 1, y = 2},
    collisionbox = PyuTestMobs.HUMAN_LIKE_CBOX,
    physical = true,
    blood_amount = PyuTestMobs.ENTITY_BLOOD_AMOUNT,
    view_range = 25,
    reach = 2,
    jump = 1,
    group_attack = true,
    group_helper = {
      "pyutest_mobs:monster",
      "pyutest_mobs:mimic"
    },
    makes_footstep_sound = true,
    textures = {
      "pyutest-necromancer.png", "pyutest-necromancer_back.png"
    },
    drops = {
      {
        name = "pyutest_core:magic_shards",
        min = 4,
        max = 8,
        chance = 1
      },
    },

    damage = 4,
    attack_chance = 1,
    attack_type = "dogshoot",
    arrow = "pyutest_mobs:arrow_necroball",
    shoot_interval = 1.2,
    shoot_offset = 0,
    pathfinding = 1,
    dogshoot_switch = 1,
    dogshoot_count_max = 5,
    dogshoot_count2_max = 6,
})
PyuTestMobs.create_boss_egg("pyutest_mobs:necromancer", "Necromancer Spawn Egg",
  "pyutest-egg.png^[multiply:dimgray", 0, nil,
  "pyutest_core:bone")
