PyuTestCore.make_item("pyutest_core:magic_shards", "Magic Shards", {}, "pyutest-magic-shards.png")
minetest.override_item("pyutest_core:enchanted_obsidian_block", {
    drop = {
      max_items = 1,
      items = {
	{
	  rarity = 3.2,
	  items = {"pyutest_core:magic_shards 3"}
	},

	{
	  items = {"enchanted_obsidian_block_obsidian_block"}
	}
      }
    }
})

PyuTestCore.registered_spellbooks = {}
PyuTestCore.make_spellbook = function (nsname, desc, color, craftitem, action)
  if action == nil then
    action = function(_, _, _)end
  end

  PyuTestCore.make_item(nsname, desc, {}, "pyutest-spellbook.png", {
      stack_max = 1,
      color = color,
      on_use = function (itemstack, user, pointed_thing)
	local pos = user:get_pos()
	minetest.sound_play({name = "spellbook_action", gain = 0.75}, {pos = pos})
	action(itemstack, user, pointed_thing)
      end
  })

  minetest.register_craft({
      output = nsname,
      recipe = {
	{"", "pyutest_core:magic_shards", ""},
	{"pyutest_core:magic_shards", craftitem, "pyutest_core:magic_shards"},
	{"", "pyutest_core:magic_shards", ""}
      }
  })

  PyuTestCore.registered_spellbooks[nsname] = {
    color = color,
    craftitem = craftitem,
    action = action
  }
end

PyuTestCore.make_spellbook("pyutest_core:explosions_spellbook", "Spellbook of Explosions", "gray", "pyutest_core:bomb", function (itemstack, user)
    PyuTestCore.create_explosion(user:get_pos(), 3, false, 7, user)
end)

PyuTestCore.make_spellbook("pyutest_core:fire_spellbook", "Spellbook of Fire", "crimson", "pyutest_core:hellstone_block", function (itemstack, user)
    local range = 2

    local function replace(pos)
      local node = minetest.get_node_or_nil(pos)
      if node == nil then return end
      if node.name ~= "air" then return end
      local pos2 = vector.new(pos.x, pos.y - 1, pos.z)
      node = minetest.get_node_or_nil(pos)
      if node == nil then return end
      if node.name ~= "air" then return end

      minetest.set_node(pos, {name = "pyutest_core:fire"})
    end

    for dx = -range, range do
      for dz = -range, range do
	local pos = user:get_pos()
	replace({x = pos.x + dx, y = pos.y, z = pos.z + dz})
      end
    end
end)


PyuTestCore.make_item("pyutest_core:enchanted_shard", "Enchanted Shard", {}, "pyutest-shard.png", {
    color = "indigo",
})

minetest.register_craft({
    output = "pyutest_core:enchanted_shard 2",
    recipe = {
      {"pyutest_core:magic_shards", "pyutest_core:diamond_shard", "pyutest_core:magic_shards"},
      {"pyutest_core:emerald_shard", "pyutest_core:magic_shards", "pyutest_core:emerald_shard"},
      {"pyutest_core:magic_shards", "pyutest_core:diamond_shard", "pyutest_core:magic_shards"}
    }
})

PyuTestCore.make_tool("pyutest_core:enchanted_pickaxe", "Enchanted Pickaxe", {}, "pyutest-enchanted-pickaxe.png", {
    stack_max = 1,
    tool_capabilities = PyuTestCore.tool_caps({
	uses = 2768,
	attack_uses = 2768 / 2,
	maxlevel = 4,
	groupcaps = {
	  cracky = {
	    times = {
	      [PyuTestCore.BLOCK_FAST] = 0.25,
	      [PyuTestCore.BLOCK_NORMAL] = 0.6,
	      [PyuTestCore.BLOCK_SLOW] = 7
	    }
	  }
	}
    }),
})

minetest.register_craft({
    output = "pyutest_core:enchanted_pickaxe",
    recipe = {
      {"pyutest_core:enchanted_shard", "pyutest_core:enchanted_shard", "pyutest_core:enchanted_shard"},
      {"", "pyutest_core:stick", ""},
      {"", "pyutest_core:stick", ""}
    }
})

PyuTestCore.make_sword("pyutest_core:enchanted_sword", "Enchanted Sword", "pyutest-enchanted-sword.png", 9, 3600, 0.7)


minetest.register_craft({
    output = "pyutest_core:enchanted_sword",
    recipe = {
      {"pyutest_core:enchanted_shard"},
      {"pyutest_core:enchanted_shard"},
      {"pyutest_core:stick"}
    }
})
