PyuTestCore.make_tool = function (nsname, desc, groups, wield_image, extra_conf)
  local conf = {
    description = Translate(desc),
    wield_image = wield_image,
    inventory_image = wield_image,
    groups = PyuTestCore.util.tableconcat(groups, {
	tool = 1
    })
  }

  if extra_conf ~= nil then
    for k, v in pairs(extra_conf) do
      conf[k] = v
    end
  end

  minetest.register_tool(nsname, conf)
end

PyuTestCore.make_tool("pyutest_core:wooden_pickaxe", "Wooden Pickaxe", {}, "pyutest-wooden-pickaxe.png", {
    stack_max = 1,
    tool_capabilities = PyuTestCore.tool_caps({
	uses = 69,
	attack_uses = 69 / 2,
	maxlevel = 1,
	groupcaps = {
	  cracky = {
	    times = {
	      [PyuTestCore.BLOCK_FAST] = 2,
	      [PyuTestCore.BLOCK_NORMAL] = 3
	    }
	  }
	}
    })
})

PyuTestCore.make_tool("pyutest_core:stone_pickaxe", "Stone Pickaxe", {}, "pyutest-stone-pickaxe.png", {
    stack_max = 1,
    tool_capabilities = PyuTestCore.tool_caps({
	uses = 274,
	attack_uses = 274 / 2,
	maxlevel = 2,
	groupcaps = {
	  cracky = {
	    times = {
	      [PyuTestCore.BLOCK_FAST] = 1.8,
	      [PyuTestCore.BLOCK_NORMAL] = 2.4
	    }
	  }
	}
    })
})

PyuTestCore.make_tool("pyutest_core:iron_pickaxe", "Iron Pickaxe", {}, "pyutest-iron-pickaxe.png", {
    stack_max = 1,
    tool_capabilities = PyuTestCore.tool_caps({
	uses = 689,
	attack_uses = 689 / 2,
	maxlevel = 3,
	groupcaps = {
	  cracky = {
	    times = {
	      [PyuTestCore.BLOCK_FAST] = 0.7,
	      [PyuTestCore.BLOCK_NORMAL] = 1.5
	    }
	  }
	}
    })
})

PyuTestCore.make_tool("pyutest_core:diamond_pickaxe", "Diamond Pickaxe", {}, "pyutest-diamond-pickaxe.png", {
    stack_max = 1,
    tool_capabilities = PyuTestCore.tool_caps({
	uses = 1345,
	attack_uses = 1345 / 2,
	maxlevel = 4,
	groupcaps = {
	  cracky = {
	    times = {
	      [PyuTestCore.BLOCK_FAST] = 0.3,
	      [PyuTestCore.BLOCK_NORMAL] = 0.8,
	      [PyuTestCore.BLOCK_SLOW] = 8
	    }
	  }
	}
    })
})

PyuTestCore.make_tool("pyutest_core:wooden_axe", "Wooden Axe", {}, "pyutest-wooden-axe.png", {
    stack_max = 1,
    tool_capabilities = PyuTestCore.tool_caps({
	uses = 69,
	attack_uses = 69 / 2,
	groupcaps = {
	  choppy = {
	    times = {
	      [PyuTestCore.BLOCK_FAST] = 1.1,
	      [PyuTestCore.BLOCK_NORMAL] = 1.6,
	      [PyuTestCore.BLOCK_SLOW] = 2.2
	    }
	  }
	}
    })
})

PyuTestCore.make_tool("pyutest_core:stone_axe", "Stone Axe", {}, "pyutest-stone-axe.png", {
    stack_max = 1,
    tool_capabilities = PyuTestCore.tool_caps({
	uses = 274,
	attack_uses = 274 / 2,
	groupcaps = {
	  choppy = {
	    times = {
	      [PyuTestCore.BLOCK_FAST] = 0.98,
	      [PyuTestCore.BLOCK_NORMAL] = 1.23,
	      [PyuTestCore.BLOCK_SLOW] = 2
	    }
	  }
	}
    })
})

PyuTestCore.make_tool("pyutest_core:iron_axe", "Iron Axe", {}, "pyutest-iron-axe.png", {
    stack_max = 1,
    tool_capabilities = PyuTestCore.tool_caps({
	uses = 689,
	attack_uses = 689 / 2,
	groupcaps = {
	  choppy = {
	    times = {
	      [PyuTestCore.BLOCK_FAST] = 0.4,
	      [PyuTestCore.BLOCK_NORMAL] = 0.6,
	      [PyuTestCore.BLOCK_SLOW] = 1.8
	    }
	  }
	}
    })
})

PyuTestCore.make_tool("pyutest_core:diamond_axe", "Diamond Axe", {}, "pyutest-diamond-axe.png", {
    stack_max = 1,
    tool_capabilities = PyuTestCore.tool_caps({
	uses = 1345,
	attack_uses = 1345 / 2,
	groupcaps = {
	  choppy = {
	    times = {
	      [PyuTestCore.BLOCK_FAST] = 0.3,
	      [PyuTestCore.BLOCK_NORMAL] = 0.4,
	      [PyuTestCore.BLOCK_SLOW] = 1.4
	    }
	  }
	}
    })
})

PyuTestCore.make_item("pyutest_core:bomb", "Bomb", {}, "pyutest-bomb.png", {
    stack_max = 16,
    on_use = function (_, user)
      if user == nil then
	return
      end
      local pos = user:get_pos()
      PyuTestCore.create_explosion(pos, 2, false, 6, user)
      local stack = user:get_wielded_item()
      stack:set_count(stack:get_count() - 1)

      user:set_wielded_item(stack)
    end
})

PyuTestCore.make_item("pyutest_core:windball", "Windball", {}, "pyutest-windball.png", {
    stack_max = 16,
    on_use = function (_, user)
      if user == nil then
	return
      end

      local pos = user:get_pos()
      minetest.sound_play({name = "spellbook_action", gain = 0.75}, {pos = pos})
      math.randomseed(os.time())
      user:add_velocity({
	  x = 0,
	  z = 0,
	  y = math.random(12, 22)
      })

      local stack = user:get_wielded_item()
      stack:set_count(stack:get_count() - 1)

      user:set_wielded_item(stack)
    end
})
