-- player setup
minetest.register_on_joinplayer(function (player)
    if player == nil then return end
    local name = player:get_player_name()
    player:set_properties({
	hp_max = 25
    })

    player:get_inventory():set_width("main", 8)
    player:get_inventory():set_size("main", 8 * 4)
    player:hud_set_hotbar_itemcount(8)

    -- creative mode privs
    if minetest.is_creative_enabled(name) then
      minetest.set_player_privs(name, PyuTestCore.util.tableconcat({
	    fly = true,
	    fast = true,
	    noclip = true,
	    builder = true,
	    settime = true,
	    creative = true,
	    peaceful_player = true, -- from mobs_redo
	    teleport = true,
      }, minetest.get_player_privs(name)))
    end
end)

-- player physics
local function set_player_speed(player, speed)
  player:set_physics_override({
      speed = speed,
  })
end

minetest.register_globalstep(function(dtime)
    local players = minetest.get_connected_players()
    for p=1, #players do
      local ctrl = players[p]:get_player_control()
      if ctrl.aux1 then
        set_player_speed(players[p], 1.60)
      else
        set_player_speed(players[p], 1)
      end
    end
end)

-- player hand
minetest.register_item(":", {
    type = "none",
    wield_image = "pyutest-hand.png"
})

if minetest.is_creative_enabled("")  then
  local break_speed = 0.2

  minetest.override_item("", {
      range = 9,
      tool_capabilities = PyuTestCore.tool_caps({
	  uses = 0,
	  time = 0.35,

	  groupcaps = {
	    crumbly = {},
	    choppy = {},
	    cracky = {},
	    snappy = {},
	    explody = {},
	    oddly_breakable_by_hand = {}
	  },

	  attack_uses = 0,
	  damage_groups = {fleshy = 10000}
      })
  })
else
  minetest.override_item("", {
      range = 5,
      tool_capabilities = PyuTestCore.tool_caps({
	  uses = 0,
	  attck_uses = 0,
	  damage_groups = {fleshy = 2},

	  groupcaps = {
	    oddly_breakable_by_hand = {
	      times = {
		[PyuTestCore.BLOCK_FAST] = 0.35,
		[PyuTestCore.BLOCK_NORMAL] = 0.50,
		[PyuTestCore.BLOCK_SLOW] = 0.65,
	      }
	    },
	    snappy = {
	      times = {
		[PyuTestCore.BLOCK_FAST] = 0.55,
		[PyuTestCore.BLOCK_NORMAL] = 0.70,
		[PyuTestCore.BLOCK_SLOW] = 0.70
	      }
	    },
	    crumbly = {
	      times = {
		[PyuTestCore.BLOCK_FAST] = 0.75,
		[PyuTestCore.BLOCK_NORMAL] = 0.80,
		[PyuTestCore.BLOCK_SLOW] = 0.90
	      }
	    },
	    choppy = {
	      times = {
		[PyuTestCore.BLOCK_FAST] = 1.2,
		[PyuTestCore.BLOCK_NORMAL] = 2.3,
		[PyuTestCore.BLOCK_SLOW] = 2.9,
	      }
	    },
	    cracky = {
	      times = {
		[PyuTestCore.BLOCK_FAST] = 6,
		[PyuTestCore.BLOCK_NORMAL] = 10,
		[PyuTestCore.BLOCK_SLOW] = 45,
	      }
	    }
	  }
      })
  })
end

-- unlimited blocks in creative mode
minetest.register_on_placenode(function(_, _, placer)
    if placer and placer:is_player() then
      return minetest.is_creative_enabled(placer:get_player_name())
    end
end)

-- player death message
minetest.register_on_dieplayer(function(player, reason)
    local playername = player:get_player_name()

    if reason.object ~= nil then
      local le = reason.object:get_luaentity()

      if le == nil then
	minetest.chat_send_all(string.format("%s was slain by %s",
	    playername, reason.object:get_player_name()))
      else
	local split = string.split(le.name, ":")
	local name = split[#split]
	name = name:gsub("_", " ")
	name = string.upper(name:sub(1, 1))..name:sub(2, name:len())
	minetest.chat_send_all(string.format("%s was slain by %s", playername, name))
      end
    end
end)
