PyuTestCore.make_building_blocks("pyutest_core:granite", "Granite", {"pyutest-granite.png"}, nil, {
    ground = 1,
    stone = 1,
    cracky = PyuTestCore.BLOCK_NORMAL,
    level = 1
})

PyuTestCore.make_building_blocks("pyutest_core:andesite", "Andesite", {"pyutest-andesite.png"}, nil, {
    ground = 1,
    stone = 1,
    cracky = PyuTestCore.BLOCK_NORMAL,
    level = 1
})

PyuTestCore.SPECIALSTONE_NOISE_PARAMS = {
  offset = 0,
  scale = 1,
  spread = {x = 250, y = 250, z = 250},
  seed = 1536,
  octaves = 3,
  persist = 0.4,
  lacunarity = 2,
  flags = "defaults"
}

minetest.register_ore({
    ore_type = "blob",
    ore = "pyutest_core:granite_block",
    wherein = "pyutest_core:stone_block",
    clust_scarcity = 9 * 9 * 9,
    clust_num_ores = 35,
    clust_size = 5,
    y_max = PyuTestCore_SurfaceBottom - 1,
    y_min = PyuTestCore_WorldBottom,
    noise_params = PyuTestCore.SPECIALSTONE_NOISE_PARAMS
})

minetest.register_ore({
    ore_type = "blob",
    ore = "pyutest_core:andesite_block",
    wherein = "pyutest_core:stone_block",
    clust_scarcity = 9 * 9 * 9,
    clust_num_ores = 35,
    clust_size = 5,
    y_max = PyuTestCore_SurfaceBottom - 1,
    y_min = PyuTestCore_WorldBottom,
    noise_params = PyuTestCore.SPECIALSTONE_NOISE_PARAMS
})

minetest.register_ore({
    ore_type = "blob",
    ore = "pyutest_core:clay_block",
    wherein = "pyutest_core:gravel_block",
    clust_scarcity = 7 * 7 * 7,
    clust_num_ores = 35,
    clust_size = 5,
    y_max = PyuTestCore_SurfaceBottom - 1,
    y_min = PyuTestCore_DeepOceanMin,
    noise_params = PyuTestCore.SPECIALSTONE_NOISE_PARAMS
})

PyuTestCore.ORE_STONES = {
  "pyutest_core:stone_block",
  "pyutest_core:granite_block",
  "pyutest_core:andesite_block",
}

-- TODO: The code here is very messy, and this function takes to much arguments. Squash the arguments into a table and clean the code.
PyuTestCore.registered_ores = {}

PyuTestCore.make_ore = function(id, desc, item_id_suffix, item_description_suffix, options)
  local default_options = {
    scarcity = 5 * 5 * 5,
    y_max = 31000,

    ore_strength = PyuTestCore.BLOCK_NORMAL,
    ore_conf = {},
    ore_groups = {},
    ore_drop = nil,
    ore_drop_count = 1,
    ore_sounds = nil,
    ore_tiles = {},
    ore_level = 1,

    item_conf = {},
    item_groups = {},
    item_texture = nil,

    make_raw = false,
    raw_conf = {},
    raw_groups = {},
    raw_texture = {},

    block_conf = {},
    block_color = nil,
    block_tiles = {},
    block_groups = {}
  }
  local conf = {}

  for k, v in pairs(options) do
    conf[k] = v
  end

  for k, v in pairs(default_options) do
    if conf[k] == nil then
      conf[k] = v
    end
  end


  local oid = id.."_ore"
  local iid = id.."_"..item_id_suffix
  local rid = conf.make_raw and id.."_raw" or nil

  minetest.register_node(oid, PyuTestCore.util.tableconcat({
	description = Translate(desc .. " Ore"),
	groups = PyuTestCore.util.tableconcat({
	  cracky = conf.ore_strength,
	  mineral = 1,
	  level = conf.ore_level
	}, conf.ore_groups),
	light_source = 2.2,
	drop = conf.ore_drop or (conf.make_raw and rid or iid) .. " " .. tostring(conf.ore_drop_count or 1),
	sounds = PyuTestCore.make_node_sounds(conf.ore_sounds),
	tiles = conf.ore_tiles
  }, conf.ore_conf))

  minetest.register_craftitem(iid, PyuTestCore.util.tableconcat({
      description = Translate(desc .. " " .. item_description_suffix),
      groups = PyuTestCore.util.tableconcat({
	  mineral = 1
      }, conf.item_groups),
      wield_image = conf.item_texture,
      inventory_image = conf.item_texture
  }, conf.item_conf))

  if conf.make_raw then
    minetest.register_craftitem(rid, PyuTestCore.util.tableconcat({
	  description = Translate("Raw " .. desc),
	  groups = PyuTestCore.util.tableconcat({
	      mineral = 1,
	      raw_mineral = 1
	  }, conf.raw_groups),
	  wield_image = conf.raw_texture,
	  inventory_image = conf.raw_texture
    }, conf.raw_conf))

    minetest.register_craft({
	type = "cooking",
	output = iid,
	recipe = rid
    })
  end

    minetest.register_ore({
      ore_type = "scatter",
      ore = oid,
      wherein = PyuTestCore.ORE_STONES,
      clust_scarcity = conf.scarcity,
      clust_num_ores = 4,
      clust_size = 3,
      y_max = conf.y_max,
      y_min = PyuTestCore_WorldBottom,
  })

  minetest.register_ore({
      ore_type = "scatter",
      ore = oid,
      wherein = PyuTestCore.ORE_STONES,
      clust_scarcity = conf.scarcity * 2.2,
      clust_num_ores = 9,
      clust_size = 3,
      y_max = conf.y_max,
      y_min = PyuTestCore_WorldBottom,
  })

  minetest.register_ore({
      ore_type = "scatter",
      ore = oid,
      wherein = PyuTestCore.ORE_STONES,
      clust_scarcity = conf.scarcity * 3,
      clust_num_ores = 18,
      clust_size = 6,
      y_max = conf.y_max,
      y_min = PyuTestCore_WorldBottom,
  })

  PyuTestCore.make_building_blocks(id, desc, conf.block_tiles, conf.block_color, PyuTestCore.util.tableconcat({
      cracky = conf.ore_strength
  }, conf.block_groups), conf.block_conf)

  local bid = id.."_block"
  minetest.register_craft({
      output = bid,
      recipe = {
	{iid, iid},
	{iid, iid}
      }
  })

  minetest.register_craft({
      output = iid .. " 4",
      recipe = {
	bid
      },
      type = "shapeless"
  })
end

-- "Primary" Ores
PyuTestCore.make_ore("pyutest_core:coal", "Coal", "lump", "Lump", {
    scarcity = 8 * 8 * 8,
    y_max = 48,

    ore_strength = PyuTestCore.BLOCK_NORMAL,
    ore_drop_count = 2,
    ore_tiles = {"pyutest-ore-coal.png"},

    item_texture = "pyutest-lump.png",
    item_conf = {
      color = {r = 32, g = 32, b = 32}
    },

    block_tiles = {"pyutest-metal.png"},
    block_color = {r = 32, g = 32, b = 32}
})

PyuTestCore.make_ore("pyutest_core:iron", "Iron", "ingot", "Ingot", {
    scarcity = 11 * 11 * 11,
    y_max = 18,

    ore_strength = PyuTestCore.BLOCK_NORMAL,
    ore_tiles = {"pyutest-ore-iron.png"},
    ore_level = 2,

    item_texture = "pyutest-ingot.png",

    make_raw = true,
    raw_texture = "pyutest-lump.png",

    block_tiles = {"pyutest-metal.png"}
})

PyuTestCore.make_ore("pyutest_core:copper", "Copper", "ingot", "Ingot", {
    scarcity = 11 * 11 * 11,
    y_max = 18,

    ore_strength = PyuTestCore.BLOCK_NORMAL,
    ore_tiles = {"pyutest-ore-copper.png"},
    ore_level = 2,

    item_texture = "pyutest-ingot.png",
    item_conf = {
      color = "darkgoldenrod",
    },

    make_raw = true,
    raw_texture = "pyutest-lump.png",
    raw_conf = {
      color = "darkgoldenrod"
    },

    block_tiles = {"pyutest-metal.png"},
    block_color = "darkgoldenrod"
})

PyuTestCore.make_ore("pyutest_core:gold", "Gold", "ingot", "Ingot", {
    scarcity = 15.5 * 15.5 * 15.5,
    y_max = -35,

    ore_strength = PyuTestCore.BLOCK_NORMAL,
    ore_tiles = {"pyutest-ore-gold.png"},
    ore_level = 3,

    item_texture = "pyutest-ingot.png",
    item_conf = {
      color = "gold"
    },

    make_raw = true,
    raw_texture = "pyutest-lump.png",
    raw_conf = {
      color = "gold"
    },

    block_tiles = {"pyutest-metal.png"},
    block_color = "gold"
})

PyuTestCore.make_ore("pyutest_core:diamond", "Diamond", "shard", "Shard", {
    scarcity = 16.7 * 16.7 * 16.7,
    y_max = -50,

    ore_strength = PyuTestCore.BLOCK_NORMAL,
    ore_tiles = {"pyutest-ore-diamond.png"},
    ore_level = 3,

    item_texture = "pyutest-shard.png",
    item_conf = {
      color = "cyan"
    },

    block_tiles = {"pyutest-metal.png"},
    block_color = "cyan"
})

PyuTestCore.make_ore("pyutest_core:emerald", "Emerald", "shard", "Shard", {
    scarcity = 18.3 * 18.3 * 18.3,
    y_max = -50,

    ore_strength = PyuTestCore.BLOCK_NORMAL,
    ore_tiles = {"pyutest-ore-emerald.png"},
    ore_level = 3,

    item_texture = "pyutest-shard.png",
    item_conf = {
      color = "seagreen"
    },

    block_tiles = {"pyutest-metal.png"},
    block_color = "seagreen"
})

-- "Secondary" Ores

PyuTestCore.make_ore("pyutest_core:zinc", "Zinc", "ingot", "Ingot", {
    scarcity = 11 * 11 * 11,
    y_max = 18,

    ore_strength = PyuTestCore.BLOCK_NORMAL,
    ore_tiles = {"pyutest-ore-zinc.png"},
    ore_level = 2,

    item_texture = "pyutest-ingot.png",
    item_conf = {
      color = "#bed3d4"
    },

    make_raw = true,
    raw_texture = "pyutest-lump.png",
    raw_conf = {
      color = "#bed3d4"
    },

    block_tiles = {"pyutest-metal.png"},
    block_color = "#bed3d4"
})

PyuTestCore.make_ore("pyutest_core:tin", "Tin", "ingot", "Ingot", {
    scarcity = 11 * 11 * 11,
    y_max = 18,

    ore_strength = PyuTestCore.BLOCK_NORMAL,
    ore_tiles = {"pyutest-ore-tin.png"},
    ore_levle = 2,

    item_texture = "pyutest-ingot.png",
    item_conf = {
      color = "#8e8591"
    },

    make_raw = true,
    raw_texture = "pyutest-lump.png",
    raw_conf = {
      color = "#8e8591"
    },

    block_tiles = {"pyutest-metal.png"},
    block_color = "#8e8591"
})
