PyuTestMapgen = {}

-- This function is used for structures because it will update the lighting when placed.
PyuTestMapgen.register_structure = function (name, schematic, def)
  local id = "pyutest_mapgen:structure_block_"..name
  minetest.register_node(id, {
      description = string.format("Structure Block (%s)", name),
      groups = {
	not_in_creative_inventory = 1
      },
      tiles = {
	"pyutest-stick.png"
      },
      walkable = false,
      pointable = false,
  })

  minetest.register_decoration({
      sidelen = 80,
      decoration = id,
      deco_type = "simple",
      place_on = def.place_on,
      spawn_by = def.spawn_by,
      num_spawn_by = def.num_spawn_by,
      fill_ratio = def.fill_ratio,
      noise_params = def.noise_params,
      flags = def.flags or "place_center_x, place_center_y, force_placement",
      biomes = def.biomes,
      y_max = def.y_max,
      y_min = def.y_min
  })

  minetest.register_lbm({
      name = "pyutest_mapgen:spawn_"..name,
      run_at_every_load = true,
      nodenames = {id},
      action = function (pos, node)
	minetest.remove_node(pos)
	minetest.place_schematic(
	  pos,
	  PyuTestCore.get_schem_path(schematic),
	  def.rotation or "random",
	  def.replacements or {},
	  def.force_placement or true,
	  def.flags or "place_center_x, place_center_z"
	)
      end
  })
end
