PyuTestCore.registered_lootboxes = {}
PyuTestCore.make_lootbox = function (name, dname, items)
  local id = name.."_lootbox"
  minetest.register_node(id, {
      description = Translate(dname .. " Lootbox"),
      groups = {
	choppy = PyuTestCore.BLOCK_NORMAL,
	not_in_creative_inventory = 1
      },
      tiles = {"pyutest-crate.png"},
      sounds = PyuTestCore.make_node_sounds(),
      drop = "",
      after_destruct = function (pos)
	for _, v in pairs(items) do
	  minetest.add_item(pos, v)
	end

	minetest.sound_play("lootbox_unlock", {
	    pos = pos,
	    gain = 1
	})
	minetest.remove_node(pos)
      end
  })
  PyuTestCore.registered_lootboxes[name] = {
    id = id,
    items = items
  }
end

PyuTestCore.make_lootbox("pyutest_core:trash", "Trash", {
    ItemStack("pyutest_core:deadbush 6"),
    ItemStack("pyutest_core:bone 3"),
    ItemStack("pyutest_core:ash 2")
})

PyuTestCore.make_lootbox("pyutest_core:resource", "Resource", {
    ItemStack("pyutest_core:gunpowder 3"),
    ItemStack("pyutest_core:stick 4"),
    ItemStack("pyutest_core:sugar 2"),
    ItemStack("pyutest_core:tree_sapling 3"),
    ItemStack("pyutest_core:apple 3"),
    ItemStack("pyutest_core:string 5")
})

PyuTestCore.make_lootbox("pyutest_core:griefer", "Griefer's Dream", {
    ItemStack("pyutest_core:tnt 3"),
    ItemStack("pyutest_core:bomb 2")
})

PyuTestCore.make_lootbox("pyutest_core:lighting", "Lighting", {
    ItemStack("pyutest_core:light 2"),
    ItemStack("pyutest_core:torch 5")
})

PyuTestCore.make_lootbox("pyutest_core:color", "Color", {
    ItemStack("pyutest_core:green_dye 2"),
    ItemStack("pyutest_core:pink_dye 3"),
    ItemStack("pyutest_core:white_dye 1"),
    ItemStack("pyutest_core:black_dye 3"),
    ItemStack("pyutest_core:brown_dye 2")
})
