PyuTestCore.registered_liquids = {}
PyuTestCore.make_liquid = function (name, desc, groups, texture, speed, extra_conf)
  local function make_liquid_flags(liquidtype)
    local drawtype = ""

    if liquidtype == "source" then
      drawtype = "liquid"
    elseif liquidtype == "flowing" then
      drawtype = "flowingliquid"
    end

    local t = PyuTestCore.util.tableconcat({
	drawtype = drawtype,
	waving = 3,
	walkable = false,
	pointable = false,
	buildable_to = true,
	is_ground_content = false,
	use_texture_alpha = "blend",
	paramtype = "light",
	drop = "",
	drowning = 3,
	liquidtype = liquidtype,
	liquid_renewable = true,
	liquid_viscosity = speed or 1,
	liquid_alternative_flowing = name.."_flowing",
	liquid_alternative_source = name.."_source",
	paramtype2 = liquidtype == "flowing" and "flowingliquid" or nil,
	special_tiles = liquidtype == "flowing" and {
	  {
	    name = texture,
	    backface_culling = false
	  },
	  {
	    name = texture,
	    backface_culling = true
	  }
	} or nil
    }, extra_conf or {})
    return t
  end

  local g = groups or {}
  g["liquid"] = 1

  PyuTestCore.make_node(name.."_source", desc .. " Source", g, {texture}, make_liquid_flags("source"))
  PyuTestCore.make_node(name.."_flowing", "Flowing " .. desc, g, {texture}, make_liquid_flags("flowing"))

  PyuTestCore.registered_liquids[name] = {
    source = name.."_source",
    flowing = name.."_flowing",
    texture = texture,
    groups = g
  }
end

PyuTestCore.make_liquid("pyutest_core:water", "Water", {
    water = 1,
    freezable = 1
}, "pyutest-water.png", 1, {
    post_effect_color = {a=60, r=24.7, g=46.3, b=89.4},
    paramtype2 = "color",
})

PyuTestCore.make_liquid("pyutest_core:lava", "Lava", {
    lava = 1
}, "pyutest-lava.png", 5, {
    damage_per_second = 4,
    light_source = 8
})
PyuTestCore.make_liquid("pyutest_core:oil", "Oil", {}, "pyutest-oil.png", 3)
PyuTestCore.make_liquid("pyutest_core:liquid_acid", "Acid", {}, "pyutest-acid.png", 7, {
    damage_per_second = 4
})
