PyuTestCore.registered_colored_blocks = {}
PyuTestCore.make_colored_blocks = function(name, desc, color)
  PyuTestCore.make_building_blocks(name.."_wool", desc.." Wool", {
      "pyutest-wool.png"
  }, color or "white", {
      oddly_breakable_by_hand = PyuTestCore.BLOCK_NORMAL,
      colored = 1
  })

  PyuTestCore.make_building_blocks(name.."_terracotta", desc .. " Terracotta", {
      "pyutest-terracotta.png"
  }, color or "white", {
      cracky = PyuTestCore.BLOCK_FAST,
      colored = 1
  })

  PyuTestCore.make_item(name.."_dye", desc.." Dye", {}, "pyutest-dye.png", {
      color = color or "white"
  })


  minetest.register_craft({
      output = name.."_wool_block",
      type = "shapeless",
      recipe = {
	"pyutest_core:white_wool_block",
	name.."_dye"
      }
  })

  minetest.register_craft({
      output = name.."_terracotta_block",
      type = "shapeless",
      recipe = {
	"pyutest_core:white_terracotta_block",
	name.."_dye"
      }
  })

  PyuTestCore.registered_colored_blocks[name] = {
    wool = name.."_wool",
    terracotta = name.."_terracotta",
    dye = name.."_dye"
  }
end

PyuTestCore.make_colored_blocks("pyutest_core:white", "White", "white")
minetest.register_craft({
    output = "pyutest_core:white_wool_block 4",
    recipe = {
      {"pyutest_core:string", "pyutest_core:string"},
      {"pyutest_core:string", "pyutest_core:string"}
    }
})

minetest.register_craft({
    type = "cooking",
    output = "pyutest_core:white_terracotta_block",
    recipe = "pyutest_core:clay_block"
})

PyuTestCore.COLORS = {
  white   = {"White",   nil},
  black   = {"Black",   {r = 32, g = 32, b = 32}},
  brown   = {"Brown",   "saddlebrown"},
  red     = {"Red",     "indianred"},
  orange  = {"Orange",  "coral"},
  yellow  = {"Yellow",  "khaki"},
  green   = {"Green",   "olivedrab"},
  blue    = {"Blue",    "cornflowerblue"},
  purple  = {"Purple",  "plum"},
  pink    = {"Pink",    "pink"},
  lime    = {"Lime",    "#64C044"}
}

for k, v in pairs(PyuTestCore.COLORS) do
  PyuTestCore.make_colored_blocks("pyutest_core:"..k, v[1], v[2])
end

PyuTestCore.make_dye_mixing_recipe = function(c1, c2, out)
  minetest.register_craft({
      type = "shapeless",
      output = out .. " 2",
      recipe = {
	c1, c2
      }
  })
end

PyuTestCore.make_dye_mixing_recipe("pyutest_core:red_dye", "pyutest_core:blue_dye", "pyutest_core:purple_dye")
PyuTestCore.make_dye_mixing_recipe("pyutest_core:red_dye", "pyutest_core:yellow_dye", "pyutest_core:orange_dye")
PyuTestCore.make_dye_mixing_recipe("pyutest_core:yellow_dye", "pyutest_core:blue_dye", "pyutest_core:green_dye")
PyuTestCore.make_dye_mixing_recipe("pyutest_core:red_dye", "pyutest_core:white_dye", "pyutest_core:pink_dye")
PyuTestCore.make_dye_mixing_recipe("pyutest_core:red_dye", "pyutest_core:green_dye", "pyutest_core:brown_dye")
