Translate = minetest.get_translator("pyutest_core")
PyuTestCore = {
  BLOCK_FAST = 3,
  BLOCK_NORMAL = 2,
  BLOCK_SLOW = 1
}
PyuTestCore_SurfaceBottom = 1
PyuTestCore_WorldTop = 31000
PyuTestCore_WorldBottom = -31000

-- these values are yoinked from VoxeLibre
-- (https://git.minetest.land/VoxeLibre/VoxeLibre/src/branch/master/mods/MAPGEN/mcl_biomes/init.lua)
PyuTestCore_OceanMin = -15
PyuTestCore_DeepOceanMax = PyuTestCore_OceanMin - 1
PyuTestCore_DeepOceanMin = -31

PyuTestCore.get_schem_path = function (name)
  return minetest.get_modpath("pyutest_mapgen") .. "/schematics/"..name..".mts"
end
PyuTestCore_Path = minetest.get_modpath("pyutest_core")

dofile(PyuTestCore_Path.."/utils.lua") -- Utilities

-- Core Game Code
-- minetest.register_alias("mapgen_dirt", "pyutest_core:dirt_block")
dofile(PyuTestCore_Path.."/blocks.lua")
dofile(PyuTestCore_Path.."/liquid.lua")
dofile(PyuTestCore_Path.."/wood.lua")
dofile(PyuTestCore_Path.."/leaves.lua")

dofile(PyuTestCore_Path.."/player.lua")
dofile(PyuTestCore_Path.."/items.lua")
dofile(PyuTestCore_Path.."/tools.lua")
dofile(PyuTestCore_Path.."/food.lua")
dofile(PyuTestCore_Path.."/combat.lua")
dofile(PyuTestCore_Path.."/wool.lua")


dofile(PyuTestCore_Path.."/flowers.lua")
dofile(PyuTestCore_Path.."/lootboxes.lua")
dofile(PyuTestCore_Path.."/ores.lua")
dofile(PyuTestCore_Path.."/abms.lua")
dofile(PyuTestCore_Path.."/magic.lua")
dofile(PyuTestCore_Path.."/crafts.lua")
dofile(PyuTestCore_Path.."/furnace.lua")

dofile(PyuTestCore_Path.."/overrides.lua")
dofile(PyuTestCore_Path.."/furniture.lua")
dofile(PyuTestCore_Path.."/electricity.lua")
