PyuTestCore.make_item = function (nsname, desc, groups, wield_image, extra_conf)
  local conf = {
    description = Translate(desc),
    wield_image = wield_image,
    inventory_image = wield_image,
    groups = groups
  }

  if extra_conf ~= nil then
    for k, v in pairs(extra_conf) do
      conf[k] = v
    end
  end

  minetest.register_craftitem(nsname, conf)
end

PyuTestCore.make_item("pyutest_core:stick", "Stick", {}, "pyutest-stick.png")

PyuTestCore.make_item("pyutest_core:bone", "Bone", {}, "pyutest-bone.png", {})

PyuTestCore.make_item("pyutest_core:gunpowder", "Gunpowder", {}, "pyutest-powder.png", {
    color = "dimgray",
})

PyuTestCore.make_item("pyutest_core:ash", "Ash", {}, "pyutest-powder.png", {
    color = "gray",
})

PyuTestCore.make_item("pyutest_core:sugar", "Sugar", {}, "pyutest-powder.png")

PyuTestCore.make_item("pyutest_core:coin", "Coin", {}, "pyutest-coin.png", {
    on_secondary_use = function (_, user)
      local pos = user:get_pos()
      minetest.sound_play({name = "coin", gain = 1}, {
	  pos = pos
      })
      return nil
    end
})

PyuTestCore.make_item("pyutest_core:wheat", "Wheat", {}, "pyutest-wheat.png")
PyuTestCore.make_item("pyutest_core:string", "String", {}, "pyutest-string.png")
PyuTestCore.make_item("pyutest_core:egg", "Egg", {}, "pyutest-egg.png", {
    color = "peachpuff"
})
PyuTestCore.make_item("pyutest_core:clay", "Clay Ball", {}, "pyutest-clay.png")
PyuTestCore.make_item("pyutest_core:glass_bottle", "Glass Bottle", {}, "pyutest-glass-bottle.png", {
    stack_max = 16
})
PyuTestCore.make_item("pyutest_core:brick", "Brick", {}, "pyutest-brick.png")
PyuTestCore.make_item("pyutest_core:snowball", "Snowball", {}, "pyutest-snowball.png")
PyuTestCore.make_item("pyutest_core:bone", "Bone", {}, "pyutest-bone.png")
