-- Nodes that are to be powered by other nodes

PyuTest.make_electricity_device("pyutest_electricity:freezer_device", "Freezer Device", {
  cracky = PyuTest.BLOCK_FAST
}, {"pyutest-freezer.png"}, "pyutest_blocks:ice_block", nil, function (pos, node, sender_pos)
  PyuTest.dorange(pos, 2, function(p)
    local n = minetest.get_node(p)

    if minetest.get_item_group(n.name, "freezable") ~= 0 then
      minetest.set_node(p, { name = "pyutest_blocks:ice_block" })
    elseif minetest.get_item_group(n.name, "coolable") ~= 0 then
      local def = minetest.registered_nodes[n.name]
      local cool_into = def.__cool_into or "pyutest_blocks:water_source"
      minetest.set_node(p, { name = cool_into })
    end
  end)
end)

PyuTest.make_electricity_device("pyutest_electricity:heater_device", "Heater Device", {
  cracky = PyuTest.BLOCK_FAST
}, {"pyutest-heater.png"}, "pyutest_blocks:fire", nil, function (pos, node, sender_pos)
  PyuTest.dorange(pos, 2, function(p)
    local n = minetest.get_node(p)

    if minetest.get_item_group(n.name, "thawable") ~= 0 then
      local def = minetest.registered_nodes[n.name]
      local thaw_into = def.__thaw_into or "pyutest_blocks:water_source"
      minetest.set_node(p, { name = thaw_into })
    elseif minetest.get_item_group(n.name, "heatable") ~= 0 then
      local def = minetest.registered_nodes[n.name]
      local heat_into = def.__heat_into or "pyutest_blocks:lava_source"
      minetest.set_node(p, { name = heat_into })
    end
  end)
end)


PyuTest.make_electricity_device("pyutest_electricity:lamp_device", "Lamp Device", {
  cracky = PyuTest.BLOCK_FAST,
}, {"pyutest-lamp.png"}, "pyutest_blocks:light", nil, function (pos, node, sender_pos)
  minetest.set_node(pos, {name = "pyutest_electricity:lamp_device_on"})
end)

PyuTest.make_electricity_device("pyutest_electricity:lamp_device_on", "Lamp Device", {
  cracky = PyuTest.BLOCK_FAST,
  not_in_creative_inventory = 1
}, {"pyutest-lamp.png"}, nil, {
  light_source = minetest.LIGHT_MAX,
  drop = "pyutest_electricity:lamp_device"
}, function (pos, node, sender_pos)
  minetest.set_node(pos, {name = "pyutest_electricity:lamp_device"})
end)
